<?php

/**
 * @package     SP LMS
 *
 * @copyright   Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

// Get Columns
$columns = $this->params->get('columns', 3);

//Load extended model
$app    				= JFactory::getApplication();
$extended_helper = JPATH_ROOT .'/templates/'.$app->getTemplate().'/html/com_splms/helper/common.php';

if (file_exists($extended_helper)) {
	require_once($extended_helper);
} else {
	die('Please install and activate lms component');
}
$commonHelper = new SplmsHelperCommon();

?>

<div id="splms" class="splms view-splms-courses">
	<?php if(count($this->items)) { ?>
	<div class="splms-courses-list">

	<?php foreach(array_chunk($this->items, $columns) as $this->items) { ?>
		<div class="splms-row">
		<?php foreach ($this->items as $key=>$this->item) {
			$course_category = $commonHelper->getCategoryById($this->item->splms_coursescategory_id);
		?>
			<div class="splms-col-sm-<?php echo round(12/$columns); ?>">
				<div class="splms-course splms-match-height">
					<div class="splms-common-overlay-wrapper">
          		<img src="<?php echo $this->item->thumb; ?>" class="splms-course-img splms-img-responsive" alt="<?php echo $this->item->title; ?>">

          		<?php if ($this->item->price == 0) {
          			echo '<span class="splms-badge-free">' . JText::_('COM_SPLMS_FREE') . '</span>';
          		} ?>
					</div>

					<div class="splms-course-info">
						<a href="<?php echo $course_category->url; ?>" class="course-category"><?php echo $course_category->title; ?></a>
						<h3 class="splms-courses-title">
							<a href="<?php echo $this->item->url; ?>">
								<?php echo $this->item->title; ?>
							</a>
						</h3>
						<div class="splms-course-time"><?php echo $this->item->course_time; ?></div>

						<!-- Has teacher -->
						<?php if (!empty($this->item->teachers)) { ?>
						<div class="splms-course-teachers">
							<span><?php echo JText::_('COM_SPLMS_BY'); ?></span>

							<?php foreach ($this->item->teachers as $teacher) {
								// Get Last Item
								$last_item = end($this->item->teachers);
							?>
							<a href="<?php echo $teacher->url; ?>" class="splms-teacher-name">
								<strong>
									<?php echo $teacher->title; ?>
								</strong>
								<?php echo ($teacher == $last_item) ? '' : ', '; ?>
							</a>
							<?php } // END:: foreach ?>
						</div>
						<?php } // END:: has teahcer ?>

						<p class="splms-course-short-info"><?php echo $this->item->short_description; ?></p>
						<div class="splms-course-meta">
							<?php echo $this->item->course_price; ?>
							<?php echo ' . '; ?>
							<?php echo count($this->item->lessons); ?>
							<?php echo JText::_('COM_SPLMS_COMMON_LESSONS'); ?>
							<?php echo ' . '; ?>
							<?php echo count($this->item->total_attachments); ?>
							<?php echo JText::_('COM_SPLMS_COMMON_ATTACHMENTS'); ?>
							<div class="course-details-btn">
								<a href="<?php echo $this->item->url; ?>" class="splms-readmore btn btn-primary">
									<?php echo $this->params->get('readmore_text', JText::_('COM_SPLMS_DETAILS')); ?> <i class="fa fa-angle-right"></i>
								</a>
							</div>
						</div>
					</div> <!-- /.splms-course-info -->
				</div> <!-- /.splms-course -->
			</div> <!-- /.splms-col-sm -->
		<?php } // END:: foreach ?>

	</div> <!-- /.splms-row -->
	<?php } // END::array_chunk ?>

	</div> <!-- /.splms-courses-list -->
	<?php } // END::has items ?>

	<?php if ($this->params->get('hide_pagination') == 0) { //Pagination ?>
		<?php if ($this->pagination->get('pages.total') >1) { ?>
			<div class="pagination">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php } ?>
	<?php } ?>

</div>
