<?php
/**
 * @package     SP LMS
 *
 * @copyright   Copyright (C) 2010 - 2015 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

JHtml::_('jquery.framework');
$input = JFactory::getApplication()->input;
$doc = JFactory::getDocument();
$user = JFactory::getUser();
$doc->addScriptdeclaration('var splms_url="'. JURI::base() .'index.php?option=com_splms";');

//Load extended model
$app    				= JFactory::getApplication();
$extended_model = JPATH_ROOT .'/templates/'.$app->getTemplate().'/html/com_splms/helper/common.php';

if (file_exists($extended_model)) {
	require_once($extended_model);
} else {
	die('Please install and activate lms component');
}

$commonHelper = new SplmsHelperCommon();
$course_category = $commonHelper->getCategoryById($this->item->splms_coursescategory_id);

?>

<div id="splms" class="splms view-splms-course course-details">
	<div class="splms-course">

		<div class="course-thumbnail">
			<?php if (!empty($this->freeLesson)) {?>
			<div class="lesson-video">
				<div id="splms-lesson-video-<?php echo $id; ?>" class="lesson-video">
					<?php if ($this->id == 'remote-host') { ?>
					<!-- player markup -->
					<div id="MainWrapper"></div>
					<div id="playlist_list">
						<!-- local tracks -->
						<div id="playlist" data-address="playlist">
							<div class="playlistNonSelected" data-address="local1" data-type="local" data-mp4="<?php echo $this->src; ?>" data-preview="<?php echo JURI::root() . $this->item->image; ?>" data-thumb="<?php echo JURI::root() . $this->item->image; ?>">
							</div>
						</div>

					</div>
					<?php } else{ ?>
					<div class="embed-responsive embed-responsive-16by9">
						<iframe src="<?php echo $this->src; ?>" width="100%" height="400" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
					</div>
					<?php } ?>
				</div>
				<script>

				</script>
			</div>
			<?php } else {?>
			<div class="course-banner-img">
				<img class="splms-img-responsive" src="<?php echo $this->item->image; ?>" alt="<?php echo $this->item->title; ?>">
			</div>
			<?php } ?>

			<?php
			if ($this->item->price == 0) {
				echo '<span class="splms-badge-free">' . JText::_('COM_SPLMS_FREE') . '</span>';
			} ?>
		</div>

		<div class="educon-course-deatils-wraper">
			<!-- start course-header -->
			<div class="course-header clearfix">
				<a href="<?php echo $course_category->url; ?>" class="course-category"><?php echo $course_category->title; ?></a>
				<h2 class="course-title"><?php echo $this->item->title; ?></h2>
				<?php if($this->review){ ?>
					<div class="rating-star">
						<?php if(isset($this->ratings) && $this->ratings->count) {
							$rating = round($this->ratings->total/$this->ratings->count);
						} else {
							$rating = 0;
						} ?>
						<?php echo JLayoutHelper::render('review.ratings', array('rating'=>$rating)); ?>
						<span class="title">(<?php echo $this->ratings->count; ?> <?php echo JTEXT::_('COM_SPLMS_RATINGS'); ?>)</span>
					</div> <!-- ?rating-star -->
				<?php } ?>
			</div> <!-- end course-header -->
			<div class="splms-course-description">
				<?php echo $this->item->description; ?>
				<div class="apply-now">
					<?php if (($this->item->price != 0) && ($this->isAuthorised == '') ) { ?>
					<form id="splms-buy-course">
						<input type="hidden" name="user_id" value="<?php echo $this->user->id; ?>">
						<input type="hidden" name="email" value="<?php echo $this->user->email; ?>">
						<input type="hidden" name="product_id" value="<?php echo $this->item->splms_course_id; ?>">
						<input type="hidden" name="product_name" value="<?php echo $this->item->title; ?>">
						<input type="hidden" name="price" value="<?php echo $this->item->price; ?>">
						<a class="btn btn-primary" id="addtocart" href="#">
							<i class="splms-icon"></i>
							<?php echo $this->coursePrice; ?> - <?php echo JText::_('COM_SPLMS_BUY_NOW'); ?>
							<i class="fa fa-angle-right"></i>
						</a>
					</form>
					<?php }elseif ($this->isAuthorised != '') { ?>
					<a class="btn btn-primary" href="javascript:void(0);">
						<i class="splms-icon"></i>
						<?php echo JText::_('COM_SPLMS_PURCHASED'); ?>
					</a>
					<?php } ?>
				</div>
			</div>
		</div>


		<div class="splms-course-introduction">
			<div class="row">
				<div class="col-sm-12">
					<h3 class="splms-title"><?php echo JText::_('COM_SPLMS_EVENT_SHORT_DESC'); ?></h3>
					<div class="splms-event-intro-info"><?php echo $this->item->short_description; ?></div> <!-- //.event-introduction-info -->
				</div> <!-- //.col-sm-6 -->
				<?php if (isset($this->item->course_infos) && is_array($this->item->course_infos)) { ?>
				<div class="col-sm-12">
					<h3 class="splms-event-title"><?php echo JText::_('COM_SPLMS_COURSE_INFO'); ?></h3>
					<ul class="splms-event-sessions-meta">
						<?php foreach ($this->item->course_infos as $course_info) { ?>
						<li>
							<h4><?php echo $course_info['info_text'] ?></h4>
							<p class="count"><?php echo $course_info['info_number'] ?></p>
						</li>
						<?php } ?>

					</ul> <!-- //.splms-event-sessions-meta -->
				</div> <!-- //.col-sm-6 -->
				<?php } ?>
			</div>
		</div> <!-- //.splms-course-introduction -->


		<!-- Has lesson -->
		<?php if(!empty($this->lessons)) {?>
		<!-- start course-lessons  -->
		<div class="course-lessons">
			<h3><?php echo JText::_('COM_SPLMS_LESSONS'); ?></h3>
			<ul class="list-unstyled">
				<?php foreach ($this->lessons as $lesson) { ?>
				<?php if ($lesson->lesson_type == 0 || $this->isAuthorised != '' || $this->item->price == 0) { ?>
				<li>
					<span>
						<a href="<?php echo $lesson->lesson_url; ?>">
							<?php echo $lesson->title; ?>
						</a>
					</span>
					<span class="pull-right">
						<?php echo JText::_('COM_SPLMS_COMMON_DURATION') . JText::_(': '); ?>
						<?php echo $lesson->video_duration; ?>
					</span>
				</li>
				<?php } else {?>
				<li class="splms-lesson-unauthorised">
					<span>
						<i class="splms-icon-lock"></i>
						<?php echo $lesson->title; ?>
					</span>
					<span class="pull-right">
						<?php echo JText::_('COM_SPLMS_COMMON_DURATION') . ': '; ?>
						<?php echo $lesson->video_duration; ?>
					</span>
				</li>
				<?php } // end else ?>

				<?php } // END:: foreach ?>
			</ul>
		</div> <!-- end course-lessons -->
		<?php } // END:: has lesson ?>


		<!-- Has quiz -->
		<?php if (!empty($this->quizzes)) { ?>
		<div class="splms-course-quizzes">
			<h3><?php echo JText::_('COM_SPLMS_QUIZ'); ?></h3>

			<ul class="list-unstyled">
				<?php foreach ($this->quizzes as $quiz) {
					$qtype = ($quiz->quiz_type == 1) ? JText::_('COM_SPLMS_PAID') : JText::_('COM_SPLMS_FREE');
					?>

					<li>
						<span>
							<i class="fa fa-question-circle"></i>
							<a href="<?php echo $quiz->url; ?>">
								<?php echo $quiz->title; ?>
							</a>
						</span>
						<span class="pull-right">
							<?php echo $qtype; ?>
						</span>
					</li>

					<?php } // END:: foreach ?>
				</ul>

			</div>
			<?php } ?>
			<!-- END::  quiz -->

			<?php if($this->show_related_courses){
						if (isset($this->related_courses) && is_array($this->related_courses)) { ?>
						<div class="splms-similar-courses">
							<h3 class="splms-title"><?php echo JText::_('COM_SPLMS_SIMILAR_CLASSES'); ?></h3>
							<div class="splms-courses-list splms">
								<div class="splms-row">
									<?php foreach ($this->related_courses as $related_course) { ?>
									<div class="splms-col-sm-4">
										<div class="splms-course">
											<a href="#">
												<img src="<?php echo $related_course->thumb; ?>" class="splms-course-img splms-img-responsive" alt="Yoga for Pregnants">
											</a>
											<div class="splms-content-wrap">
												<h4 class="splms-course-title">
													<a href="<?php echo $related_course->url; ?>"><?php echo $related_course->title; ?></a>
												</h4>
												<div class="splms-course-cat">
													<?php echo $related_course->category_name; ?>
												</div>
												<div class="splms-course-time">
													<?php echo $related_course->course_time; ?>
												</div>
												<div class="splms-course-details-btn">
													<a href="<?php echo $related_course->url; ?>" class="btn btn-primary"><?php echo JText::_('COM_SPLMS_DETAILS'); ?></a>
												</div>
											</div> <!-- /.splms-content-wrap -->
										</div> <!-- /.splms-course -->
									</div> <!-- //.splms-col-sm-4 -->
									<?php } ?>
								</div> <!-- /.splms-row -->
							</div><!-- //.splms-courses-list -->
						</div> <!-- //.splms-similar-courses -->
						<?php } ?>
						<?php } ?>

			<?php if (isset($this->item->course_schedules) && $this->item->course_schedules && count($this->item->course_schedules)) { ?>
			<div class="splms-course-class-rotuines">
				<div class="splms-class-routines">
					<h3 class="splms-title"><?php echo JText::_('COM_SPLMS_CLASS_TIMES'); ?></h3>
					<table class="table table-bordered">
						<thead>
							<tr>
								<?php foreach ($this->schedule_days as $schedule_day) { ?>
								<th><?php echo $schedule_day; ?></th>
								<?php } ?>
							</tr>
						</thead>
						<tbody>
							<tr>
								<?php foreach ($this->schedule_days as $schedule_day) { ?>
								<td class="splms-class-routines-day-<?php echo $schedule_day; ?>">
									<?php if (!in_array($schedule_day, $this->hasdays)) { ?>
									<div class="splms-class-routines-text no-schedule">
										<?php } ?>
										<?php foreach ($this->item->course_schedules as $course_schedule) { ?>
											<?php if ($schedule_day == $course_schedule['day']) { ?>
											<div class="splms-class-routines-text has-schedule">
												<?php echo $course_schedule['text']; ?>
											</div>
											<?php } ?>
										<?php } // foreach course_schedules?>
									</td>
									<?php } //foreach schedule_days ?>
								</tr>
							</tbody>
						</table>
					</div>
				</div> <!-- //.splms-course-class-rotuines -->
				<?php } ?>

				<?php if($this->review){ ?>
				<div class="clearfix"></div>
				<div class="user-reviews">
					<div class="reviews-menu">
						<div class="title-wrap">
							<h3 class="title"><?php echo JText::_('COM_SPLMS_REVIEWS'); ?></h3>
							<div class="myreviews-wrap">
								<ul class="list-inline list-style-none">
									<?php if($this->myReview) { ?>
									<li><a id="splms-my-review" class="btn btn-primary" href="#"><i class="splms-icon-write"></i> <?php echo JText::_('COM_SPLMS_EDIT_REVIEW'); ?></a></li>
									<?php } ?>

									<?php if($user->guest) { ?>
									<li><a href="<?php echo JRoute::_('index.php?option=com_users&view=login&return=' . base64_encode('index.php?option=com_splms&view=course&id=' . $this->item->id . ':' . $this->item->alias . SplmsHelper::getItemid('courses'))); ?>" class="btn btn-primary"><i class="fa fa-pencil-square-o"></i> <?php echo JText::_('COM_SPLMS_LOGIN_TO_REVIEW'); ?></a></li>
									<?php } ?>
								</ul>
							</div>
						</div>

						<div class="reviews-wrapper">
							<div class="reviews-status">
								<?php if(isset($this->ratings) && $this->ratings->count) {
									$rating = round($this->ratings->total/$this->ratings->count);
								} else {
									$rating = 0;
								} ?>
								<span class="total"><?php echo $rating; ?></span>
								<div class="sp-lms-rating ">
									<?php echo JLayoutHelper::render('review.ratings', array('rating'=>$rating)); ?>
								</div>
								<p class="avg-rating"><?php echo JText::_('COM_SPLMS_REVIEW_AVARAGE_RATING'); ?></p>
							</div>
							<div class="total-reviews">
								<div class="sp-lms-rating ">
									<?php echo JLayoutHelper::render('review.ratings', array('rating'=>$rating)); ?>
								</div>
								<?php echo round($rating / (5 / 100),2); ?>% <span class="total-review"><?php echo count($this->reviews); ?> Ratings</span>
							</div>
						</div>
					</div> <!--/.reviews-menu -->
					<div class="clearfix"></div>

					<?php echo JLayoutHelper::render('review.form', array('review'=>$this->myReview, 'item_id'=>$this->item->id, 'url'=>'index.php?option=com_splms&view=course&id=' . $this->item->id . ':' . $this->item->alias . SplmsHelper::getItemid('courses'))); ?>

					<div id="reviews">
						<?php foreach ($this->reviews as $key => $this->review) {
							echo JLayoutHelper::render('review.review', array('review'=>$this->review));
						} ?>
					</div>

					<?php if($this->showLoadMore) { ?>
					<a id="splms-load-review" class="btn btn-link btn-lg btn-block" data-item_id="<?php echo $this->item->id; ?>" href="#"><i class="fa fa-refresh"></i> <?php echo JText::_('COM_SPLMS_REVIEW_LOAD_MORE'); ?></a>
					<?php } ?>
				</div><!--/.user-reviews-->
				<?php } ?>

				<!-- Has teacher -->
				<?php if (!empty($this->teachers)) {?>
				<div class="splms-course-teachers">
					<h3><?php echo JText::_('COM_SPLMS_MEET_OUR_COURSE_TEACHER'); ?></h3>
					<div class="splms-row">
						<?php foreach ($this->teachers as $teacher) { ?>
						<div class="splms-col-sm-3">
							<div class="splms-course-teacher">
								<a href="<?php echo $teacher->url; ?>"><img src="<?php echo $teacher->image; ?>" alt="<?php echo $teacher->title; ?>"></a>
								<h4><a href="<?php echo $teacher->url; ?>"><?php echo $teacher->title; ?></a></h4>
								<small><?php echo $teacher->specialist_in; ?></small>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
				<?php } ?>
				<!-- END::  teacher -->
			</div>
		</div>
