<?php
/**
* @package RSMediaGallery!
* @copyright (C) 2015 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

defined('_JEXEC') or die;

class plgInstallerRSMediaGallery extends JPlugin
{
	public function onInstallerBeforePackageDownload(&$url, &$headers)
	{
		$uri 	= JUri::getInstance($url);
		$parts 	= explode('/', $uri->getPath());
		
		if ($uri->getHost() == 'www.rsjoomla.com' && in_array('com_rsmediagallery', $parts)) {			
			if (!file_exists(JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/version.php')) {
				return;
			}
			
			// Load our version
			require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/version.php';
			
			// Load language
			JFactory::getLanguage()->load('plg_installer_rsmediagallery');
			
			// Get the version
			$version = new RSMediaGalleryVersion;
			
			// Get the update code
			$componentParams = JComponentHelper::getParams('com_rsmediagallery');
			$code 			 = $componentParams->get('code');
			
			// No code added
			if (!strlen($code)) {
				JFactory::getApplication()->enqueueMessage(JText::_('PLG_INSTALLER_RSMEDIAGALLERY_MISSING_UPDATE_CODE'), 'warning');
				return;
			}
			
			// Code length is incorrect
			if (strlen($code) != 20) {
				JFactory::getApplication()->enqueueMessage(JText::_('PLG_INSTALLER_RSMEDIAGALLERY_INCORRECT_CODE'), 'warning');
				return;
			}
			
			// Compute the update hash			
			$uri->setVar('hash', md5($code.$version->key));
			$uri->setVar('domain', JUri::getInstance()->getHost());
			$uri->setVar('code', $code);
			$url = $uri->toString();
		}
	}
}
