function rsmg_init_content_equal_size($) {
	if (!responsive_content) {
		var max = 0;
		var current_items = [];
		if ($('.rsmg_content_container').length == 0) return;
		var old_top = $('.rsmg_content_container').offset().top;
		var last	= $('.rsmg_content_container').length - 1;
		$('.rsmg_content_container').each(function(index, el) {
			var top = $(el).offset().top;
			if (old_top != top)
			{
				for (var i=0; i<current_items.length; i++)
					if (max > 0)
						current_items[i].css('height', max);
				
				top 	= $(el).offset().top;
				old_top = top;
				max 	= 0;
				current_items.length = 0;
			}
			
			max = Math.max(max, $(el).height());
			current_items.push($(el));
			
			if (index == last)
			{
				for (var i=0; i<current_items.length; i++)
					if (max > 0)
						current_items[i].css('height', max);
			}
		});
		if(center_list_content) {
			rsmg_align_center_content($, false);
		}
		rsmg_content_equal_size_thumb_details($);
	}
	else {
		rsmg_equal_size_responsive_content($, false);
	}
}
function rsmg_equal_size_responsive_content($, mix, reccuring) {
	if (typeof reccuring == 'undefined') {
		reccuring = 0;
	}
	$('.rsmg_gallery').each(function(){
		var filters_present = $(this).find('.rsmg_content_gallery_filters').length;
		if (!filters_present) {
			rsmg_remake_clear($, $(this));
		}
		
		var offsets = [];
		var item_data = [];
		
		var items = [];
		
		$(this).find('.rsmg_content_gallery li .rsmg_content_container').each(function(){
			if ($(this).parent().css('display') != 'none') {
				offsets.push(Math.round($(this).offset().top));
				items.push($(this).parent());
				items_offsets = {};
				items_offsets.top = Math.round($(this).offset().top); 
				
				items_offsets.bottom = Math.round($(this).offset().top);
				items_offsets.bottom = items_offsets.bottom + $(this).find('img').height(); 
				
				item_data.push(items_offsets);
				
			}
		});
		var counts 		 = countOccurances(offsets);
		
		var itemsrow_content = 0;
		for(var i=0; i < item_data.length; i++) {
			item_data[i].row = counts[item_data[i].top];
			if (itemsrow_content <= item_data[i].row) {
				itemsrow_content = item_data[i].row;
			}
		}
		
		var new_offsets = rsmg_break_array($, offsets);
		
		$.each(new_offsets, function(index,val) { 
			var row = index;
			$.each(val, function(k,v) {
				var item = (itemsrow_content * row) + k;
				
				if(items[item]) {
					var margin_left = parseInt(items[item].css('margin-left'));
					if (k!=0) {
						if(margin_left == 0) {
							if (mix){
								items[item].css('-webkit-transition','margin-left linear 0.3s');
								items[item].css('-moz-transition','margin-left linear 0.3s');
								items[item].css('-o-transition','margin-left linear 0.3s');
								items[item].css('transition','margin-left linear 0.3s');
							}
							if (filters_present) {
								items[item].removeClass('margin_left_none');
							}
						}
						
					}
					else {
						if(margin_left != 0) {
							if (mix){
								items[item].css('-webkit-transition','margin-left linear 0.3s');
								items[item].css('-moz-transition','margin-left linear 0.3s');
								items[item].css('-o-transition','margin-left linear 0.3s');
								items[item].css('transition','margin-left linear 0.3s');
							}
							if (filters_present) {
								items[item].addClass('margin_left_none');
							}
						}
					}
				}
			});
			
		});
		
		if (reccuring <= 2) {
			var new_item_bottoms = {};
			
			for(var i=0; i < item_data.length; i++) {
				if (!new_item_bottoms[item_data[i].top]) {
					new_item_bottoms[item_data[i].top] = rsmg_get_bottoms($, item_data,counts[item_data[i].top], item_data[i].top);
				}
				
			}
			var height_modified = false;
		
			$.each(items, function(index, item) { 
				var current_offset_top = item_data[index].top;
				
				if (counts[current_offset_top] > 1 ) {
						
					var biggest_bottom = Math.max.apply(null, new_item_bottoms[current_offset_top]);
					var diff = biggest_bottom - current_offset_top;
					
					if (diff > 0) {
						
						if (mix){
							$(item).find('.rsmg_content_container').animate({height: diff+"px"}, 500);
						}
						else {
							$(item).find('.rsmg_content_container').height(diff);
						}
						height_modified = true;
					}
				}
				else {
					var new_height = 0;
					new_height = $(item).find('img').height();	
				
					if (mix){
						$(item).find('.rsmg_content_container').animate({height: new_height+"px"}, 500);
					}
					else {
						$(item).find('.rsmg_content_container').height(new_height);
					}
					
					height_modified = true;
					
				}
			});
			
			if(center_list_content) {
				rsmg_align_center_content($, mix);
			}
			if (height_modified && filters_present) {
				if (mix) {
					timeoutID = setTimeout(function(){
						rsmg_equal_size_responsive_content($, mix, (reccuring+1));
					}, 600);
				} else {
					rsmg_equal_size_responsive_content($, mix, (reccuring+1));
				}					
			}
		}	
	
	});
	rsmg_content_equal_size_thumb_details($);
	
}

// function used when layout responsive and the mixing is not enabled
function rsmg_remake_clear($, container) {
	var cont_w = container.width();
	
	container.find('.rsmg_content_gallery > .rsmg_gallery_clear_all').remove();
	container.find('.rsmg_content_gallery > .margin_left_none').removeClass('margin_left_none');
	
	
	var items_row_w = 0;
	container.find('.rsmg_content_gallery > li').each(function(index, element){
		if (items_row_w == 0) {
			$(element).addClass('margin_left_none');	
		}
		var outerWidth = Math.floor($(element).outerWidth(true));
		items_row_w = items_row_w + outerWidth;
		
		if ((items_row_w + outerWidth - 1) > cont_w) {
			$(element).after('<li class="rsmg_gallery_clear_all"></li>');
			items_row_w = 0;
		}
	});
}

// function for the thumb details container

function rsmg_content_equal_size_thumb_details($) {
	$('.rsmg_content_th_inner_wrap').each(function(index, element){
		var parent_w = $(element).parents('.rsmg_content_thumb_details').width();
		$(element).width(parent_w);
	});
}

function countOccurances(vector) {
	var counts = {};

	for(var i = 0; i< vector.length; i++) {
		var num = vector[i];
		counts[num] = counts[num] ? counts[num]+1 : 1;
	}
	return counts;
}

function rsmg_get_bottoms($, item_data , row, diff_top) {
	var heights = [];
	for(var i=0; i< item_data.length; i++) {
		if(item_data[i].row == row && item_data[i].top == diff_top) {
			heights.push(item_data[i].bottom);
		}
	}
	return heights;
}

function rsmg_break_array($, array) {
	var new_arrays = [];
	array = array.sort();
	var counts = countOccurances(array);
	
	var slice_val = 0;
	
	var i = 0;
	$.each(counts, function(index,val) {
		new_arrays[i] = array.slice(slice_val, (slice_val + val));
		slice_val = slice_val + val;
		i++;
	});
	
	return new_arrays;
}

function rsmg_set_tags_filters_content($) {
	var visibleTags = [];
	
	$('.rsmg_content_gallery li').each(function(){
		var classes = $(this).attr('class');
		if (classes) {
			classes = classes.split(' ');
			if (classes.length > 0) {
				for (var i=0; i < classes.length; i++) {
					if (classes[i] != 'mix' && classes[i] != 'mix_all') {
						visibleTags.push(classes[i]);
					}
				}
			}
		}
	});
	if (visibleTags.length > 0) {
		var uniqueArray = visibleTags.filter(function(elem, pos) {
			return visibleTags.indexOf(elem) == pos;
		});
		
		var isAnimation = $('.rsmg_content_gallery_filters').length;
		if (isAnimation > 0) {
			$('.rsmg_content_gallery_filters li').each(function(){
				var tag = $(this).attr('data-filter');
				if (tag != 'all'){
					if (uniqueArray.indexOf(tag) > -1) {
						$(this).fadeIn(600);
					}
				}
			});
		}
	}
}

function rsmg_init_same_mix_size_content($){
	var offsets = [];
	$('ul.rsmg_content_gallery li').each(function(){
		if ($(this).css('display') == 'block' ) {
			offsets.push($(this).find('.rsmg_content_container').offset().top);
		}
	});
	var uniqueOffsets = [];
	$.each(offsets, function(index,elem) {
		if (uniqueOffsets.indexOf(elem) == -1) {
			uniqueOffsets.push(elem);
		}
	});

	for (var i=0; i<uniqueOffsets.length; i++) {
		var offsetsImagesHeights = [];
		
		$('ul.rsmg_content_gallery li').each(function(){
			if ($(this).css('display') == 'block' ) {
				if (uniqueOffsets[i]==$(this).find('.rsmg_content_container').offset().top) {
					var imgHeight = $(this).find('.rsmg_content_container').find('a > img').height();
					offsetsImagesHeights.push(imgHeight);
				}
			}
		});
		
		var newContainerHeight = Math.max.apply(null, offsetsImagesHeights); ;
		
		$('ul.rsmg_content_gallery li').each(function(){
			if ($(this).css('display') == 'block' ) {
				if (uniqueOffsets[i]==$(this).find('.rsmg_content_container').offset().top) {
					$(this).find('.rsmg_content_container').animate({height: newContainerHeight+"px"}, 500);
				}
			}
		});	
	}
	if(center_list_content) {
		rsmg_align_center_content($, true);
	}
}

function rsmg_align_center_content($, mix) {
	$('.rsmg_gallery').each(function(){
		var offsets = [];
		var img_cont_w = 0;
		var margin_cont = 0;
		
		$(this).find('.rsmg_content_gallery li').each(function(){
			if ($(this).css('display') == 'block') {
				offsets.push($(this).find('.rsmg_content_container').offset().top);
				if(img_cont_w == 0 ) {
					if (responsive_content) {
						img_cont_w = $(this).width();
					}
					else {
						img_cont_w = $(this).find('.rsmg_content_container').width();
					}
				}
				if (margin_cont == 0) {
					if (responsive_content) {
						margin_cont = parseInt($(this).css('margin-left'));
					}
					else {
						margin_cont = parseInt($(this).css('margin-right'));
					}				
				}
				
				if (responsive_content) {
					var width_li_cont = $(this).width();
					var masterContainer = $(this).find('.rsmg_content_container');
					var width_gallery_cont = $(masterContainer).outerWidth();
					var innerMargin = (width_li_cont - width_gallery_cont) / 2;
					$(masterContainer).css('margin-left',innerMargin);
				}
				
			}
		});
		
		
		var counts 		 = countOccurances(offsets);
		var disp_per_row = 0;
		for(var i=0; i < offsets.length; i++) {
			if (disp_per_row < counts[offsets[i]]) {
				disp_per_row = counts[offsets[i]];
			}
		}
		
		var main_w = $(this).find('.rsmg_content_gallery').parent().width();
		
		var img_cont_padding_left = $('.rsmg_content_container').css('padding-left');
		img_cont_padding_left = parseInt(img_cont_padding_left);
		
		var img_cont_padding_right = $('.rsmg_content_container').css('padding-right');
		img_cont_padding_right = parseInt(img_cont_padding_right);
		
		var img_cont_border = 2;
		if (responsive_content) {
			var img_cont_total_w = img_cont_w;
		}
		else {
			var img_cont_total_w = img_cont_w + img_cont_padding_left + img_cont_padding_right + img_cont_border;
		}
		var max_per_row = Math.floor(main_w / img_cont_total_w);
		
		
		if (offsets.length >= max_per_row) {
			disp_per_row = max_per_row;
		}
		
		if(disp_per_row == 0) disp_per_row = 1;
		
		if (disp_per_row == 1) {
			var indent = 0;
		}
		else {
			var indent = margin_cont * disp_per_row;
		}
		
		if (indent == 0) indent = img_cont_padding_left + img_cont_padding_right + img_cont_border;
		
		if (responsive_content) {
			var set_margin = (main_w - (((img_cont_w + indent) * (disp_per_row -1)) + img_cont_w)) / 2;
		}
		else {
			var set_margin = (main_w - ((img_cont_w + indent) * disp_per_row)) / 2;
		}
		
		if (max_per_row > disp_per_row) {
			set_margin = set_margin + margin_cont;
		}	
		set_margin = (set_margin>0 ? set_margin : 0);
		
		
		if(mix) {
			$(this).find('.rsmg_content_gallery').animate({
				marginLeft: set_margin+"px"}, 500);
		} else {
			
			$(this).find('.rsmg_content_gallery').css('margin-left',set_margin);
		}
	});
}


jQuery(document).ready(function($) {
	if (responsive_content) {
		$('.rsmg_gallery').hide();
		$(window).load(function() {
			$('.rsmg_gallery').show();
			rsmg_init_content_equal_size(jQuery);
		});
	}	
	$(document).piroBox_content({
		piro_speed: 700,
		bg_alpha: 0.5,
		piro_scroll: true,
		htmlClass: 'content',
		selector: 'a[class*="pirobox_gall_content"]'
	});
	
	if (!responsive_content) {
		$(window).load(function() { 
			rsmg_init_content_equal_size(jQuery);
		});
	}
	rsmg_set_tags_filters_content(jQuery);
	
	
	
	if (responsive_content || center_list_content) {
		$(window).resize(function () {
			if (responsive_content) rsmg_equal_size_responsive_content($, false);
			if (center_list_content && !responsive_content) rsmg_align_center_content($, false);
		});
	}
});

if (!Array.prototype.indexOf)
{
  Array.prototype.indexOf = function(elt /*, from*/)
  {
    var len = this.length >>> 0;

    var from = Number(arguments[1]) || 0;
    from = (from < 0)
         ? Math.ceil(from)
         : Math.floor(from);
    if (from < 0)
      from += len;

    for (; from < len; from++)
    {
      if (from in this &&
          this[from] === elt)
        return from;
    }
    return -1;
  };
}