<?php
/**
* @package com_splms
* @subpackage  mod_splmupcomingevents
*
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

// import component helper
jimport('joomla.application.component.helper');
jimport('joomla.filesystem.file');

// Get Thumb
$params = JComponentHelper::getParams('com_splms');
$thumb_size_small = strtolower($params->get('event_thumbnail_small', '100X60'));

?>

<div class="mod-splms-upcoming-events <?php echo $moduleclass_sfx; ?>">
	<?php if(count($items)){ ?>
		<ul class="splms-upcoming-events-lists">
			<?php foreach ($items as $item) {?>
			<li class="splms-upcoming-event clearfix">
				<a href="<?php echo $item->url; ?>">
					<?php
					$filename = basename($item->image);
					$path = JPATH_BASE .'/'. dirname($item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size_small . '.' . JFile::getExt($filename);
					$src = JURI::base(true) . '/' . dirname($item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size_small . '.' . JFile::getExt($filename);

					if(JFile::exists($path)) {
						$thumb = $src;
					} else {
						$thumb = $this->item->image;
					}
					?>
					<a href="<?php echo $item->url; ?>">
						<img src="<?php echo $thumb; ?>" class="splms-event-img splms-img-responsive" alt="<?php echo $item->title; ?>">
					</a>
				</a>
				<small class="splms-upcoming-event-date">
					<?php echo JHtml::_('date', $item->event_start_date, 'DATE_FORMAT_LC'); ?>
				</small>

				<strong class="splms-upcoming-event-title">
					<a href="<?php echo $item->url; ?>" class="splms-event-title"><?php echo $item->title; ?></a>
				</strong>
			</li>
			<?php } ?>
		</ul>
	<?php } else { ?>
		<p><?php echo JTEXT::_('COM_SPLMS_NO_ITEMS_FOUND');  ?></p>
	<?php } ?>
</div>
