<?php
/**
* @package com_splms
* @subpackage  mod_splmscourses
*
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

jimport( 'joomla.filesystem.file' );

//Joomla Component Helper & Get LMS Params
jimport('joomla.application.component.helper');
$splmsparams = JComponentHelper::getParams('com_splms');

//Get Currency
$currency = explode(':', $splmsparams->get('currency', 'USD:$'));
$currency =  $currency[1];

// Get image thumb
$thumb_size = strtolower($splmsparams->get('course_thumbnail_small', '100X60'));

?>

<div class="mod-splms-courses <?php echo $moduleclass_sfx; ?>">

	<ul class="splms-courses-list">
		<?php foreach ($items as $item) { ?>
		<?php $item->price = ($item->price == 0) ? JText::_('MOD_SPLMS_COURSES_FREE') : SplmsHelper::generateCurrency($item->price, $item->sale_price); ?>
		<li class="mod-splms-course clearfix">
			<a href="<?php echo $item->url; ?>">
				<?php
				$filename = basename($item->image);
				$path = JPATH_BASE .'/'. dirname($item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size . '.' . JFile::getExt($filename);
				$src = JURI::base(true) . '/' . dirname($item->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $thumb_size . '.' . JFile::getExt($filename);

				if(JFile::exists($path)) {
					$thumb = $src;
				} else {
					$thumb = $item->image;	
				}
				?>
				<a href="<?php echo $item->url; ?>">
					<img src="<?php echo $thumb; ?>" class="splms-course-img splms-img-responsive" alt="<?php echo $item->title; ?>">
				</a>
			</a>

			<strong class="splms-course-title">
				<a href="<?php echo $item->url; ?>" class="splms-course-title"><?php echo $item->title; ?></a>
			</strong>

			<div class="mod-splms-course-price">
				<?php echo $item->price; ?>
			</div>

		</li>
		<?php } ?>
	</ul>
</div>

<?php
