<?php
/**
 * @package       RSMediaGallery! Showcase
 * @copyright (C) 2016 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * Class instagramElements
 */
class instagramElements
{
	/**
	 * @var string
	 */
	public $tags;

	/**
	 * @var string
	 */
	public $user_id;

	/**
	 * @var string
	 */
	public $access_token;

	/**
	 * @var int
	 */
	public $limit;

	/**
	 * @var int
	 */
	public $thumb_width;

	/**
	 * @var string
	 */
	public $id_type;

	/**
	 * instagramElements constructor.
	 *
	 * @param $params
	 *
	 * @throws
	 *
	 */
	public function __construct($params)
	{
		$this->access_token = $params->get('instagram_access_token');
		$this->user_id      = null;

		if (isset($this->access_token))
		{
			$user_id       = explode('.', $this->access_token);
			$this->user_id = $user_id[0];
		}

		//$this->id_type      = $params->get('instagram_feed', 'user');
		$this->id_type = 'user';
		$this->tags    = null;

		$this->limit       = $params->get('limit', 10);
		$this->thumb_width = $params->get('th_width', 100);

		if ($this->user_id === $this->access_token)
		{
			throw new Exception(JText::_('MOD_RSMEDIAGALLERY_SHOWCASE_INSTAGRAM_NO_USER_ID'));
		}

		if ($this->access_token === null)
		{
			throw new Exception(JText::_('MOD_RSMEDIAGALLERY_SHOWCASE_INSTAGRAM_NO_ACCESS_TOKEN'));
		}

	}

	/**
	 * Cache the query results
	 *
	 * @return array
	 */
	public function getItems()
	{
		$items = array();
		// Initialize caching
		$cache = JFactory::getCache('mod_rsmediagallery_showcase');
		$cache->setCaching(true);

		if ($data = $cache->call(array('instagramElements', 'getElements'), $this->access_token, $this->user_id, $this->limit, $this->tags, $this->id_type))
		{
			foreach ($data as $dataset)
			{
				foreach ($dataset as $photo)
				{

					if ($photo->type == 'image')
					{
						$item = (object) array();
						if (!empty($photo->caption->text))
						{
							$item->title = $photo->caption->text;
						}
						else
						{
							$item->title = '';
						}
						$item->thumb       = $this->getBestThumb($photo->images);
						$item->url         = $photo->images->standard_resolution->url;
						$item->full        = $photo->images->standard_resolution->url;
						$item->description = $photo->filter;
						$items[]           = $item;
					}
				}
			}
		}

		return $items;

	}

	protected function getBestThumb($item)
	{

		if ($this->thumb_width <= 150)
		{
			return $item->thumbnail->url;
		}
		elseif ($this->thumb_width > 150 && $this->thumb_width <= 320)
		{
			return $item->low_resolution->url;
		}
		else
		{
			return $item->standard_resolution->url;
		}

	}

	/**
	 * Based on the module parameters, grab the needed media
	 *
	 * @param      $access_token
	 * @param      $user_id
	 * @param      $limit
	 * @param null $tags
	 * @param      $id_type
	 *
	 * @return array
	 */
	public static function getElements($access_token, $user_id, $limit, $tags = null, $id_type)
	{
		$items = array();

		$http = JHttpFactory::getHttp();

		switch ($id_type)
		{
			case 'user':
				$url = 'https://api.instagram.com/v1/users/' . $user_id . '/media/recent/?access_token=' . $access_token . '&count=' . $limit;
				break;
			case 'tags':
				$url = 'https://api.instagram.com/v1/tags/' . $tags . '/media/recent?access_token=' . $access_token . '&count=' . $limit;
				break;
			case 'popular':
				$url = 'https://api.instagram.com/v1/media/popular?access_token=' . $access_token . '&count=' . $limit;
				break;
		}

		$response = $http->get($url, array(), 3);
		$response = json_decode($response->body);

		if ($response != 'NULL' && isset($response->data))
		{
			$items[] = $response->data;
		}

		return $items;
	}
}