<?php
/**
* @version 1.0.0
* @package RSMediaGallery! Responsive Slideshow Module 1.0.0
* @copyright (C) 2013 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/
defined('_JEXEC') or die('Restricted access');

if (file_exists(JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/helper.php') && file_exists(JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/jquery.php'))
{
	jimport('joomla.application.component.helper');

	require_once dirname(__FILE__).'/helper.php';
	
	require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/helper.php';
	require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/jquery.php';

	$app			 = JFactory::getApplication();
	$componentParams = JComponentHelper::getParams('com_rsmediagallery');
	$jqueryHelper 	 = RSMediaGalleryjQuery::getInstance();
	$document		 = JFactory::getDocument();

	// JS
	$jqueryHelper->addjQuery();
	$document->addScriptDeclaration("jQuery.noConflict();");
	
	// CSS
	$document->addStyleSheet(JURI::root(true).'/modules/mod_rsmediagallery_responsive_slideshow/assets/css/style.css');

	$use_original		 = (int) $params->get('use_original', 0);
	$open_in_new_page	 = (int) $params->get('open_in_new_page', 1);
	$show_controls		 = (int) $params->get('show_controls', 1);
	$show_title			 = (int) $params->get('show_title', 1);
	$show_description	 = (int) $params->get('show_description', 1);
	$show_indicators 	 = (int) $params->get('show_indicators', 1);
	$indicators_position = $params->get('indicators_position', 'right-inline-top');
	$items_per_slide 	 = (int) $params->get('items_per_slide', 1);
	$span 				 = floor(12 / $items_per_slide);
	$moduleclass_sfx	 = $params->get('moduleclass_sfx','');
	$center_element 	 = $params->get('center_element', 1);
	$title_tag 			 = RSMediaGalleryHelper::escape($params->get('title_tag', 'h3'));
	$effect				 = $params->get('slider_effect', 'slide');

	$tags 				 = $params->get('tags');
	$order 				 = $params->get('ordering', 'ordering');
	$direction			 = $params->get('direction', 'ASC');
	$limit 				 = $params->get('limit', '5');
	
	$status_captions 	 = $params->get('status_captions', 'show-all');

	$gallery_params		 = RSMediaGalleryHelper::parseParams($params);

	$items = array();
	if ($tags) {
		$items = RSMediaGalleryHelper::getItems($tags, $order, $direction, 0, $limit);
		if (empty($items)) { 
			$app->enqueueMessage(JText::sprintf('MOD_RSMEDIAGALLERY_RESPONSIVE_SLIDESHOW_PARAM_TAGS_NO_RESULTS', $tags), 'error');
		}
	} else {
		$app->enqueueMessage(JText::sprintf('MOD_RSMEDIAGALLERY_RESPONSIVE_SLIDESHOW_PARAM_TAGS_NO_RESULTS', $tags), 'error');
	}

	// calculating slider width or height
	if ($items) 
		foreach ($items as $i => $item) {
			$item->from = 'mod_rsmediagallery_responsive_slideshow';
			$items[$i] = RSMediaGalleryHelper::parseItem($item, $gallery_params);
		}

	$max_height = 0;
	$max_width	= 0;

	if ($use_original)
	{
		if ($items) {
			foreach ($items as $item) {
				if ($item->params = $item->params ? unserialize($item->params) : array()) {
					$max_width = max($max_width, $item->params['info'][0]);
					$max_height = max($max_height, $item->params['info'][1]);
				}
			}
		}
	}
	else
	{
		if ($items) {
			foreach ($items as $item) {
				if ($item->params = $item->params ? unserialize($item->params) : array()) {
					if ($params->get('thumb_height') == 0) {
						$max_width  = $params->get('thumb_width');
						$max_height = $item->thumb_height;
					} else {
						$max_width  = $item->thumb_width;
						$max_height = $params->get('thumb_height');
					}
				}
			}
		}
	}

	$container_height = $max_height;

	if ($items) 
	{
		$slideshow = modRSMediaGalleryResponsiveSlideshowHelper::getInstance();
		$slideshow->carousel('rsmg_rsp_container'.$module->id, $params);
		
		$caption_class = $slideshow->getCaptionClass($status_captions);
		// Display template
		require JModuleHelper::getLayoutPath('mod_rsmediagallery_responsive_slideshow');
	}
}
else
	JError::raiseWarning(500, JText::_('MOD_RSMEDIAGALLERY_RESPONSIVE_SLIDESHOW_COMPONENT_NOT_INSTALLED_OR_UPDATED'));