<?php
/**
* @version 1.0.0
* @package RSMediaGallery! Responsive Slideshow Module 1.0.0
* @copyright (C) 2013 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/
defined('_JEXEC') or die('Restricted access');

class modRSMediaGalleryResponsiveSlideshowHelper
{
	protected $is30;
	
	public function __construct() {
		$version 	= new JVersion();
		$this->is30 = $version->isCompatible('3.0');
	}
	
	public static function getInstance() {
		static $inst;
		if (!$inst) {
			$inst = new modRSMediaGalleryResponsiveSlideshowHelper();
		}
		return $inst;
	}
	
	public function carousel($selector, $params) {
		$stop_over 	= (int) $params->get('stop_over', 1);
		$interval  	= (int) $params->get('interval', 5000);
		$autoplay 	= (int) $params->get('autoplay', 1);
		$effect		= $params->get('slider_effect', 'slide');
		
		$options = '{'.($autoplay ? '"interval": '.$interval.', ': '').'"pause": "'.($stop_over ? 'hover' : '').'", "effect":"'.$effect.'"'.(!$autoplay ? ', "paused":true': '').($this->is30 ? ', "doCycle":true':'').'}'; 
		
		$root = JURI::root(true);
		$document = JFactory::getDocument();
		
		$document->addCustomTag('<link rel="stylesheet" href="'.$root.'/modules/mod_rsmediagallery_responsive_slideshow/assets/css/bootstrap-carousel.css" type="text/css" />');
		$document->addCustomTag('<link rel="stylesheet" href="'.$root.'/modules/mod_rsmediagallery_responsive_slideshow/assets/css/bootstrap-carousel-'.$effect.'-effect.css" type="text/css" />');
		$document->addScript($root.'/modules/mod_rsmediagallery_responsive_slideshow/assets/js/jcarousel.js?v=1');
		$document->addScript($root.'/modules/mod_rsmediagallery_responsive_slideshow/assets/js/jquery.touchSwipe.min.js?v=1');

		$document->addScriptDeclaration(
			"
			jQuery(document).ready(function($){
				$('.$selector').each(function(index, element) { $(this)[index].slide = null; });

				$('.$selector').rscarousel(".$options.");

				$('.$selector .carousel-inner .item').swipe( {
						//Generic swipe handler for all directions
						swipeLeft:function(event, direction, distance, duration, fingerCount) {
							$(this).parents('.$selector').rscarousel('next'); 
						},
						swipeRight: function() {
							$(this).parents('.$selector').rscarousel('prev'); 
						},
						threshold:50
					});
				
			});
			"
		);
	}
	
	public function getCaptionClass($status) {
		$classes = '';
		
		if ($status != 'show-all') {
			$devices = explode('-', $status);
			if (in_array('phones', $devices)) {
				$classes .= 'visible-phone ';
			}
			if (in_array('tablets', $devices)) {
				$classes .= 'visible-tablet ';
			}
			if (in_array('desktop', $devices)) {
				$classes .= 'visible-desktop ';
			}
		}
		
		return trim($classes);
	}
}