<?php
/**
 * @version       1.0.0
 * @package       RSMediaGallery! Responsive Slider Module 1.0.0
 * @copyright (C) 2013 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('_JEXEC') or die('Restricted access');

$attr = array(
	'id'    => $this->selector,
	'class' => 'slick-carousel ' . $slider_class . ' ' . $this->selector . ' ' . RSMediaGalleryHelper::escape($moduleclass_sfx)
);

?>
<div class="row-fluid">
	<div class="span12">
		<div <?php echo $this->add_attributes($attr) ?>>
			<?php foreach ($items as $item):

				/**
				 * Build Item Specific Settings
				 */

				// Item
				$itemAttr = array(
					'class' => 'rstpl-slider-main-image',
					'style' => 'background-image:url(' . $item->full . ')',
				);

				// Captions
				$container = array(
					'class' => 'rstpl-caption ' . $caption_class,
				);

				// Title
				$title = array(
					'class'          => 'animated',
					'data-animation' => $animate_title,
				);

				if ($title_color)
				{
					$title['style'] = 'color:' . $title_color;
				}

				$title = array_filter($title);

				// Subtitle - description
				$description = array(
					'class'          => 'animated',
					'data-animation' => $animate_description,
				);

				if ($description_color)
				{
					$description['style'] = 'color:' . $description_color;
				}

				$description = array_filter($description);

				// Link
				$url = array(
					'class'          => 'animated btn ' . $button_color,
					'data-animation' => $animate_button,
					'href'           => $item->url
				);

				if ($open_in_new_page)
				{
					$url['target'] = '_blank';
				}

				$url      = array_filter($url);

				if ($enableParallax)
				{
					$itemAttr['data-center']                 = 'background-position: 50% 0px;';
					$itemAttr['data-top-bottom']             = 'background-position: 50% -150px;';
					$container['data-start']                 = 'opacity:1;';
					$container['data-' . round($height / 2)] = 'opacity:0;';
				}

				?>
				<!-- Slider Item -->
				<div class="item">
					<div <?php echo $this->add_attributes($itemAttr) ?>>
						<?php if ($show_title || $show_description || $show_url): ?>
							<div <?php echo $this->add_attributes($container) ?>>

								<?php if ($show_title): ?>
									<h2 <?php echo $this->add_attributes($title) ?>>
										<?php echo RSMediaGalleryHelper::escape($item->title) ?>
									</h2>
								<?php endif ?>

								<?php if ($show_description): ?>
									<p <?php echo $this->add_attributes($description) ?>>
										<?php echo $item->description ?>
									</p>
								<?php endif ?>

								<?php if ($show_url && isset($url['href'])): ?>
									<a <?php echo $this->add_attributes($url) ?>>
										<?php echo JText::_('MOD_RSMEDIAGALLERY_URL_LABEL') ?>
									</a>
								<?php endif ?>

							</div>
						<?php endif ?>
					</div>
				</div>
				<!-- / Slider Item -->
			<?php endforeach ?>
		</div>
	</div>
</div>
