<?php
/**
 * @version       1.0.0
 * @package       RSMediaGallery! Responsive Slider Module 1.0.0
 * @copyright (C) 2013 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/licenses/gpl-3.0.html
 */

defined('JPATH_PLATFORM') or die;

JFormHelper::loadFieldClass('list');

/**
 * Class JFormFieldRSFont
 */
class JFormFieldRSFont extends JFormFieldList
{

	protected $type = 'RSFont';

	public static function getFonts()
	{
		$key = 'AIzaSyB6U3dJj9tQw-1eTzfoJ_cI08srQn7thjI';
		$url = 'https://www.googleapis.com/webfonts/v1/webfonts?key=' . $key;

		try
		{
			$http = JHttpFactory::getHttp();
			if ($response = $http->get($url, null, 5))
			{

				if ($response->code != 200)
				{
					throw new Exception(JText::sprintf('LIB_RSMEDIAGALLERY_CONNECTION_ERROR', $response->code));
				}

				$data = json_decode($response->body);

				if ($data === null)
				{
					throw new Exception(JText::_('LIB_RSMEDIAGALLERY_COULD_NOT_DECODE_JSON_DATA'));
				}

				if (!isset($data->items))
				{
					throw new Exception(JText::_('LIB_RSMEDIAGALLERY_JSON_DATA_CONTAINS_NO_ITEMS'));
				}

				$list = array('Template Default');

				foreach ($data->items as $item)
				{
					if (!empty($item->family))
					{
						$list[] = $item->family;
					}
				}

				return $list;
			}
		} catch (Exception $e)
		{
			$application = JFactory::getApplication();
			$application->enqueueMessage($e->getMessage(), 'error');
		}

		return array();
	}

	public function getOptions()
	{
		$cache = JFactory::getCache('mod_rsmediagallery_responsive_slider');
		$cache->setCaching(true);
		$fonts = $cache->call(array('JFormFieldRSFont', 'getFonts'));
		foreach ($fonts as $font)
		{
			$options[] = JHtml::_('select.option', $font);
		}

		return $options;
	}

}
