jQuery(document).ready(function ($) {

	var wrap = function (selector, addThisClass) {
		var select = selector.parent().parent();
		$(select).next().andSelf().wrapAll('<div class="' + addThisClass + '" />');
	}

	// organize the form fields

	wrap($('#jform_params_show_indicators'), 'float-elements');
	wrap($('#jform_params_caption_style'), 'float-elements');
	wrap($('#jform_params_autoplay'), 'float-elements');
	wrap($('#jform_params_stop_over'), 'float-elements');

	wrap($('#jform_params_gradient_start_color'), 'float-elements');
	wrap($('#jform_params_gradient_end_color'), 'float-elements');

	wrap($('#jform_params_ordering'), 'float-elements');
	wrap($('#jform_params_show_title-lbl'), 'float-elements');
	wrap($('#jform_params_show_description-lbl'), 'float-elements');
	wrap($('#jform_params_show_url-lbl'), 'float-elements');
	wrap($('#jform_params_vertical_position-lbl'), 'float-elements');

	// group the gradient / solid colors options
	var gradient = $("#jform_params_gradient_solid").parent().parent();
	gradient = gradient.nextAll().slice(0, 3);
	gradient.addClass('overlay-gradient');

	var solid = $("#jform_params_gradient_solid").parent().parent();
	solid = solid.nextAll().slice(3, 5);
	solid.addClass('overlay-solid');

	// depending on the selection we hide what we don't use
	var gradientOrSolid = $('#jform_params_gradient_solid').find('input:radio');

	if (gradientOrSolid.filter(':checked').attr('id') == 'jform_params_gradient_solid0') {
		$('.overlay-solid, .overlay-gradient').hide('fast');
	} else if (gradientOrSolid.filter(':checked').attr('id') == 'jform_params_gradient_solid1') {
		$('.overlay-gradient').show();
		$('.overlay-solid').hide();
	} else {
		$('.overlay-solid').show();
		$('.overlay-gradient').hide();
	}

	// handle the click event
	gradientOrSolid.click(function () {
		if ($(this).attr('id') == 'jform_params_gradient_solid1') {
			$('.overlay-solid').slideUp('fast');
			$('.overlay-gradient').slideToggle('fast');
		} else if ($(this).attr('id') == 'jform_params_gradient_solid2') {
			$('.overlay-gradient').slideUp('fast');
			$('.overlay-solid').slideToggle('fast');
		} else {
			$('.overlay-gradient, .overlay-solid').slideUp('fast');
		}
	});

});
