<?php
/**
 * @package       RSMediaGallery! Showcase
 * @copyright (C) 2014 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * Class instagramSlider
 */
class instagramSlider
{

	/**
	 * @var string
	 */
	private $user_id;

	/**
	 * @var string
	 */
	private $access_token;

	/**
	 * @var int
	 */
	public $limit;

	/**
	 * instagramSlider constructor.
	 *
	 * @param $params
	 *
	 * @throws
	 *
	 */
	public function __construct($params)
	{
		$this->access_token = $params->get('instagram_access_token');
		$this->user_id      = null;

		if (isset($this->access_token))
		{
			$user_id       = explode('.', $this->access_token);
			$this->user_id = $user_id[0];
		}

		$this->limit = $params->get('limit');

		if ($this->user_id === null)
		{
			throw new Exception(JText::_('MOD_RSMEDIAGALLERY_SHOWCASE_INSTAGRAM_NO_USER_ID'));
		}

		if ($this->access_token === null)
		{
			throw new Exception(JText::_('MOD_RSMEDIAGALLERY_SHOWCASE_INSTAGRAM_NO_ACCESS_TOKEN'));
		}

	}

	/**
	 * Cache the query results
	 *
	 * @return array
	 */
	public function getItems()
	{
		$items = array();
		// Initialize caching
		$cache = JFactory::getCache('mod_rsmediagallery_responsive_slider');
		$cache->setCaching(true);

		if ($data = $cache->call(array('instagramSlider', 'getElements'), $this->access_token, $this->user_id, $this->limit))
		{
			foreach ($data as $dataset)
			{
				foreach ($dataset as $photo)
				{
					if ($photo->type == 'image')
					{

						$item = (object) array();
						if (!empty($photo->caption->text))
						{
							$item->title = $photo->caption->text;
						}
						else
						{
							$item->title = '';
						}
						$item->thumb       = $photo->images->standard_resolution->url;
						$item->url         = $item->thumb;
						$item->full        = $item->thumb;
						$item->description = $photo->filter;
						$items[]           = $item;
					}
				}
			}
		}

		return $items;

	}

	/**
	 * Based on the module parameters, grab the needed media
	 *
	 * @param      $access_token
	 * @param      $user_id
	 * @param      $limit
	 *
	 * @return array
	 */
	public static function getElements($access_token, $user_id, $limit)
	{
		$items = array();

		$http = JHttpFactory::getHttp();

		$url = 'https://api.instagram.com/v1/users/' . $user_id . '/media/recent/?access_token=' . $access_token . '&count=' . $limit;

		$response = $http->get($url, array(), 3);
		$response = json_decode($response->body);

		if ($response != 'NULL' && isset($response->data))
		{
			$items[] = $response->data;
		}

		return $items;
	}
}