<?php
/**
* @version 1.0.0
* @package RSMediaGallery! Advanced Slideshow Module 1.0.0
* @copyright (C) 2013 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/
defined('_JEXEC') or die('Restricted access');

if (file_exists(JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/helper.php') && file_exists(JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/jquery.php'))
{
	jimport('joomla.application.component.helper');

	require_once dirname(__FILE__).'/helper.php';
	require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/helper.php';
	require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/jquery.php';

	$componentParams = JComponentHelper::getParams('com_rsmediagallery');
	$jqueryHelper 	 = RSMediaGalleryjQuery::getInstance();
	$document		 = JFactory::getDocument();

	// CSS
	// handle template overrides
	modRSMediaGallerySlideshowAdvHelper::_addStyleSheet('style.css');
	modRSMediaGallerySlideshowAdvHelper::_addStyleSheet($componentParams->get('contrast', 'light').'.css');
	$src = JDEBUG ? '.src' : '';

	// JS
	$jqueryHelper->addjQuery();
	$document->addScriptDeclaration("jQuery.noConflict();");
	$document->addScript(JURI::root(true).'/modules/mod_rsmediagallery_adv_slideshow/assets/js/jquery.easing.1.3'.$src.'.js');
	$document->addScript(JURI::root(true).'/modules/mod_rsmediagallery_adv_slideshow/assets/js/jquery.skitter'.$src.'.js');

	$theme				= $params->get('slideshow_type', 'square');
	$effect				= $params->get('effect', 'cubeRandom');
	$auto_play			= (int) $params->get('auto_play', 1);
	$stop_over			= (int) $params->get('stop_over', 1);
	$interval			= (int) $params->get('interval', 2500);
	$show_progressbar	= (int) $params->get('show_progressbar', 1);
	$show_prev_next		= (int) $params->get('show_prev_next', 1);
	$show_controls		= (int) $params->get('show_controls', 1);
	$controls_position	= $params->get('controls_position', 'center');
	$navigation_type	= $params->get('navigation_type', 'dots_thumbs');
	$navigation_align	= $params->get('navigation_align', 'center');
	$show_label			= (int) $params->get('show_label', 1);
	$label_animation	= $params->get('label_animation', 'slideUp');
	$use_original		= (int) $params->get('use_original', 0);
	$open_in_new_page	= (int) $params->get('open_in_new_page', 1);
	$moduleclass_sfx	= $params->get('moduleclass_sfx','');

	$use_url			= $params->get('use_url', 1);
	$tags 				= $params->get('tags');
	$order 				= $params->get('ordering', 'ordering');
	$direction			= $params->get('direction', 'ASC');
	$limit 				= $params->get('limit', '5');

	$gallery_params		= RSMediaGalleryHelper::parseParams($params);

	switch ($navigation_type) {
		case 'none':
			$navigation = "dots: false,\n\tnumbers: false,\n";
		break;
		
		case 'dots':
			$navigation = "dots : 'true',\n";
		break;
		
		case 'dots_thumbs':
			$navigation = "dots : 'true',\n\tpreview : true,\n";
		break;
		
		case 'thumbs':
			$navigation = "thumbs : 'true',\n";
		break;
		
		case 'numbers':
			$navigation = "numbers : 'true',\n";
		break;
		
		default:
			$navigation = '';
		break;
	}

	$items = array();

	if ($tags) {
		$items = RSMediaGalleryHelper::getItems($tags, $order, $direction, 0, $limit);
		if (empty($items)) { 
			JFactory::getApplication()->enqueueMessage(JText::sprintf('COM_RSMEDIAGALLERY_PARAM_TAGS_NO_RESULTS', $tags), 'error');
		}
	} else {
		JFactory::getApplication()->enqueueMessage(JText::sprintf('COM_RSMEDIAGALLERY_PARAM_TAGS_NO_RESULTS', $tags), 'error');
	}

	// calculating slider width or height
	if ($items) {
		foreach ($items as $i => $item) {
			$item->from = 'mod_rsmediagallery_adv_slideshow';
			$items[$i] = RSMediaGalleryHelper::parseItem($item, $gallery_params);
			
			if (!$use_url) {
				$items[$i]->url = 'javascript:void(0);';
			}
		}
	}

	$max_height = 0;
	$max_width	= 0;

	if ($use_original)
	{
		if ($items) {
			foreach ($items as $item) {
				if ($item->params = $item->params ? unserialize($item->params) : array()) {
					$max_width = max($max_width, $item->params['info'][0]);
					$max_height = max($max_height, $item->params['info'][1]);
				}
			}
		}
	}
	else
	{
		if ($items) {
			foreach ($items as $item) {
				if ($item->params = $item->params ? unserialize($item->params) : array()) {
					if ($params->get('thumb_height') == 0) {
						$max_width  = $params->get('thumb_width');
						$max_height = $item->thumb_height;
					} else {
						$max_width  = $item->thumb_width;
						$max_height = $params->get('thumb_height');
					}
				}
			}
		}
	}

	$container_height = ( $navigation_type == 'dots' || $navigation_type == 'dots_thumbs' ? ($max_height+40) : $max_height );

	if ($items) 
	{
		$document->addStyleDeclaration('
			#rsmg_adv_mod_container'.$module->id.' .rsmg_adv_mod_box .preview_slide {
				height:'.(100 * ($max_height/$max_width)).'px;
			}
			#rsmg_adv_mod_container'.$module->id.' .rsmg_adv_mod_box {
				height: '.$container_height.'px;
				width:'.$max_width.'px;
			}
		');

		$document->addScriptDeclaration("
			jQuery(document).ready(function($){
				jQuery('#rsmg_adv_mod_slider$module->id').skitter({
					id: ".$module->id.",
					theme: '".RSMediaGalleryHelper::escape($theme)."',
					animation: '".RSMediaGalleryHelper::escape($effect)."',
					auto_play: ".($auto_play ? 'true' : 'false').",
					stop_over: ".($stop_over ? 'true' : 'false').",
					interval: ".$interval.",
					progressbar: ".($show_progressbar ? 'true' : 'false').",
					progressbar_css: { width: ".$max_width." },
					navigation: ".($show_prev_next ? 'true' : 'false').",
					controls: ".($show_controls ? 'true' : 'false').",
					controls_position: '".RSMediaGalleryHelper::escape($controls_position)."',
					".$navigation."
					numbers_align: '".RSMediaGalleryHelper::escape($navigation_align)."',
					label: ".($show_label ? 'true' : 'false').",
					labelAnimation: '".RSMediaGalleryHelper::escape($label_animation)."',
					width_skitter : ".$max_width.",
					height_skitter : ".$max_height."
					
				});
			});
		");

		// Display template
		require JModuleHelper::getLayoutPath('mod_rsmediagallery_adv_slideshow');
	}
}
else
	JError::raiseWarning(500, JText::_('MOD_RSMEDIAGALLERY_ADV_SLIDESHOW_COMPONENT_NOT_INSTALLED_OR_UPDATED'));