var RSShowcaseScript = {}

RSShowcaseScript.$ = jQuery;

RSShowcaseScript.Init = {

	Start: function (params) {
		RSShowcaseScript.$(window).load(function ($) {

			RSShowcaseScript.Init.Load(params);

			RSShowcaseScript.$(window).resize(function () {
				RSShowcaseScript.Init.OnResize(params.id);
			});
		});
	},

	Load: function (params) {
		var container = params.id;

		var containerTop = RSShowcaseScript.$(container).offset().top;
		var $top = RSShowcaseScript.$(window).scrollTop();

		if (containerTop <= RSShowcaseScript.$(window).height() || $top > ( containerTop - RSShowcaseScript.$(window).height() )) {
			RSShowcaseScript.$(container).find('.rsp_picture').each(function (i) {
				RSShowcaseScript.$(this).delay((i++) * 200).fadeTo(600, 1);
			});
		} else {
			RSShowcaseScript.$(window).scroll(function () {
				$top = RSShowcaseScript.$(window).scrollTop();
				if ($top > ( containerTop - RSShowcaseScript.$(window).height() )) {
					RSShowcaseScript.$(container).find('.rsp_picture').each(function (i) {
						RSShowcaseScript.$(this).delay((i++) * 200).fadeTo(600, 1);
					});
				} else if (RSShowcaseScript.$(window).scrollTop() + RSShowcaseScript.$(window).height() == RSShowcaseScript.$(document).height()) {
					RSShowcaseScript.$(container).find('.rsp_picture').each(function (i) {
						RSShowcaseScript.$(this).delay((i++) * 200).fadeTo(600, 1);
					});
				}
			});
		}

		// resize to fit the with of the container
		this.Resize(container);

		// center the images inside the div if necessary
		this.CenterElements(container);

		// on click actions
		this.ClickEvents(params);
	},

	OnResize: function (container) {
		RSShowcaseScript.$(container).css('padding-left', '0px');
		RSShowcaseScript.$(container).find('.rsp_picture_container:hidden').show();  // if there are pictures hidden from preview window resize

		// resize to fit the with of the container
		this.Resize(container);
	},

	CenterElements: function (container) {
		RSShowcaseScript.$(container).find('.rsp_picture').each(function (index, val) {
			var img_cont_w = RSShowcaseScript.$(val).width();

			var img = RSShowcaseScript.$(val).find('img');
			var img_w = img.width();
			var img_h = img.height();

			if (img_h > img_cont_w) {
				var diff = img_h - img_cont_w;
				img.css('margin-top', -(diff / 2));
			}

			if (img_w > img_cont_w) {
				var diff = img_w - img_cont_w;
				img.css('margin-left', -(diff / 2));
			}
		});
	},

	ClickEvents: function (params) {
		if (params.openIn == 'slideshow') {
			RSShowcaseScript.$(params.id + ' > .rsp_picture_container').on('click', function () {
				RSShowcaseLightbox.Settings.show_title = params.title;
				RSShowcaseLightbox.Settings.show_description = params.description;
				RSShowcaseLightbox.Settings.show_pictures_numbering = params.numbering;
				RSShowcaseLightbox.Actions.Load(RSShowcaseScript.$(this), false);
			});
		} else if (params.openIn == 'url'){
			RSShowcaseScript.$(params.id + ' > .rsp_picture_container').on('click', function(){
				var url = RSShowcaseScript.$(this).find('.rsp_picture a').attr('href');
				var target = RSShowcaseScript.$(this).find('.rsp_picture a').attr('target');
				window.open(url, (typeof target == 'undefined' ? '_self' : target));
			});
		}
	},

	Resize: function (container) {
		var offsets = [];
		RSShowcaseScript.$(container).find('.rsp_picture_container').each(function () {
			offsets.push(RSShowcaseScript.$(this).offset().top);
		});

		var counts = this.countOccurrences(offsets);
		var found_per_row = 0;
		for (var i = 0; i < offsets.length; i++) {
			if (found_per_row < counts[offsets[i]]) {
				found_per_row = counts[offsets[i]];
			}
		}

		var nr_left_pictures = offsets.length % found_per_row;
		if (nr_left_pictures > 0) RSShowcaseScript.$(container + ' > .rsp_picture_container').slice(-nr_left_pictures).hide();

		var pictures_container_margin = (parseInt(RSShowcaseScript.$(container + ' > .rsp_picture_container').css('margin-left')) * 2) * found_per_row;
		var pictures_container_w = (RSShowcaseScript.$(container + ' > .rsp_picture_container').width() * found_per_row) + pictures_container_margin;

		var cont_padding_left = (RSShowcaseScript.$(container).width() - pictures_container_w) / 2;
		if (cont_padding_left >= 0) {
			RSShowcaseScript.$(container).css('padding-left', cont_padding_left + 'px');
		}
	},

	countOccurrences: function (vector) {
		var counts = {};
		for (var i = 0; i < vector.length; i++) {
			var num = vector[i];
			counts[num] = counts[num] ? counts[num] + 1 : 1;
		}
		return counts;
	},

}