jQuery(document).ready(function ($) {
	var carousels = $('.slick-carousel');

	function carouselData(index, context) {
		var item = index,
			activeItem = $(context).find('[data-slick-index="' + item + '"]'),
			inactiveItems = $(context).find('.item').not(activeItem),
			caption = activeItem.find('.rstpl-caption'),

			data = {
				caption         : caption,
				inactiveCaptions: $(inactiveItems).find('.rstpl-caption')
			};

		if (activeItem.prev().length) {
			data['prevImg'] = activeItem.prev().find('.rstpl-slider-main-image').css('background-image').replace(/.*\s?url\([\'\"]?/, '').replace(/[\'\"]?\).*/, '');
		}
		if (activeItem.next().length) {
			data['nextImg'] = activeItem.next().find('.rstpl-slider-main-image').css('background-image').replace(/.*\s?url\([\'\"]?/, '').replace(/[\'\"]?\).*/, '');
		}

		return data;
	}

	function randomAnimation() {
		var animations = [
			// fades
			"fadeIn",
			"fadeInUp",
			"fadeInDown",
			"fadeInRight",
			"fadeInLeft",
			// bounces
			"bounceIn",
			"bounceInUp",
			"bounceInDown",
			"bounceInRight",
			"bounceInLeft",
			// zooms
			"zoomIn",
			"zoomInUp",
			"zoomInDown",
			"zoomInRight",
			"zoomInLeft",
			// specials
			"lightSpeedIn",
			"flipInX",
			"flipInY"
		];

		return animations[Math.floor(Math.random() * animations.length)];
	}


	carousels.each(function () {

		$(this).on('init', function (slick) {
			// Init Skrollr
			if ($(this).hasClass('parallax-enabled')) {
				var s = skrollr.init({
					mobileCheck: function () {
						//hack - forces mobile version to be off
						return false;
					},
					forceHeight: false
				});
			}


			$currentItem = $(this).find('.slick-current');
			$currentItemIndex = parseInt($currentItem.attr('data-slick-index'));

			if (!$(this).hasClass('instagram-slider')) {
				data = carouselData($currentItemIndex, this);

				$('.rstpl-car-previous').append('<div class="prev-img" style="background-image:url(' + data.prevImg + ')"></div>');
				$('.rstpl-car-next').append('<div class="next-img" style="background-image:url(' + data.nextImg + ')"></div>');
				$(data.caption).find('h2, p, a').each(function () {
					var animation = $(this).attr('data-animation');

					if (animation == 'random') {
						$(this).addClass(randomAnimation()).css('opacity', 1);
					} else {
						$(this).addClass(animation).css('opacity', 1);
					}

				});
			}
		});

		$(this).on('beforeChange', function (slick, currentSlide, nextSlide) {

			$currentItem = $(this).find('.slick-current');
			$currentItemIndex = parseInt($currentItem.attr('data-slick-index'));

			if (!$(this).hasClass('instagram-slider')) {
				data = carouselData($currentItemIndex, this);

				$(data.inactiveCaptions).find('h2, p, a').each(function () {
					var animation = $(this).attr('data-animation');
					if (animation == 'random') {
						self = $(this);
						classes = $(this).attr("class").split(' ');

						$.each(classes, function (i, c) {
							if (c.indexOf("fade") === 0 || c.indexOf("bounce") === 0 || c.indexOf("zoom") === 0 || c.indexOf("flip") === 0 || c.indexOf("light") === 0) {
								$(self).removeClass(c).css('opacity', 0);
							}
						});

					} else {
						$(this).removeClass(animation).css('opacity', 0);
					}
				});
			}
		});

		$(this).on('afterChange', function (slick, currentSlide) {
			$currentItem = $(this).find('.slick-current');
			$currentItemIndex = parseInt($currentItem.attr('data-slick-index'));

			if (!$(this).hasClass('instagram-slider')) {
				data = carouselData($currentItemIndex, this);
				$('.prev-img').css('background-image', 'url(' + data.prevImg + ')');
				$('.next-img').css('background-image', 'url(' + data.nextImg + ')');

				$(data.caption).find('h2, p, a').each(function () {

					var animation = $(this).attr('data-animation');
					if (animation == 'random') {
						$(this).addClass(randomAnimation()).css('opacity', 1);
					} else {
						$(this).addClass(animation).css('opacity', 1);
					}
				});
			}

		});

	});


});

