<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewTeachers extends JViewLegacy{

	protected $items;
	protected $params;
	protected $layout_type;

	function display($tpl = null) {
		// Assign data to the view
		$model = $this->getModel();
		$this->items = $this->get('items');
		$this->pagination	= $this->get('Pagination');

		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();
		
		$this->layout_type = str_replace('_', '-', $this->params->get('layout_type', 'default'));

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JLog::add(implode('<br />', $errors), JLog::WARNING, 'jerror');
			return false;
		}

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

		foreach ($this->items as $this->item) {
			// Generate URL
			$this->item->url = JRoute::_('index.php?option=com_splms&view=teacher&id='.$this->item->id.':'.$this->item->alias . SplmsHelper::getItemid('teachers'));
			//Get Teachers Lessons
			$this->item->teacher_total_lessons= count($lessons_model->getTeacherLessons($this->item->id));

			$specialistist_decodes = json_decode($this->item->specialist_in);
			if (isset($specialistist_decodes) && is_object($specialistist_decodes)) {
				$specialists = array();
				foreach ($specialistist_decodes as $key => $specialistist_decode) {
					$specialists[] = $specialistist_decode->specialist_text;
				}
				$this->item->specialist_in = implode(', ', $specialists);
			}
		}

		//Generate Item Meta
        SplmsHelper::itemMeta();
		parent::display($tpl);
	}

}
