<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewSpeaker extends JViewLegacy{

	protected $item;
	protected $params;
	function display($tpl = null) {
		// Assign data to the view
		$this->item = $this->get('Item');
		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}
		// Load courses & lesson Model
		$model = JModelLegacy::getInstance( 'Speakers', 'SplmsModel' );

		// Encode Speker ID
		$splms_speaker_id_encode= '%"'.$this->item->id.'"%';
		// Get Speaker events
		$this->speaker_events = $model->getSpeakerEvents($splms_speaker_id_encode);
		
		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = $this->item->title;
        $cleanText              = $this->item->description;
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if ($this->item->image) {
        	$itemMeta['image']      = JURI::base() . $this->item->image;
        }
        SplmsHelper::itemMeta($itemMeta);

		parent::display($tpl);
	}

}