<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewQuizquestion extends JViewLegacy{

	protected $item;
	protected $params;

	function display($tpl = null) {
		// Assign data to the view
		$this->item 	= $this->get('Item');
		$app 			= JFactory::getApplication();
		$this->params 	= $app->getParams();
		$menus 			= JFactory::getApplication()->getMenu();
		$menu 			= $menus->getActive();

		// Import Joomla component helper
		jimport('joomla.application.component.helper');
		//get Component Params
		$this->lmsParams = JComponentHelper::getParams('com_splms');
		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		// Load courses & lesson Model
		$quiz_model  	= JModelLegacy::getInstance( 'Quizquestions', 'SplmsModel' );
		$courses_model 	= JModelLegacy::getInstance( 'Courses', 'SplmsModel' );
		
		// Get login user ID
		$user = JFactory::getUser();
		$userId = $user->id;
		// guest doensn't access
		if($user->guest) {
			echo '<p class="alert alert-danger">' . JText::_('COM_SPLMS_QUIZ_LOGIN') . '</p>';
			return;	
		}

		$this->isAuthorised = $courses_model->getIsbuycourse($userId, $this->item->course_id);
		$this->courese  	= $courses_model->getCourse($this->item->course_id);
		// check authorised or free quiz
		if(!$this->isAuthorised && $this->item->quiz_type > 0) {
			$output  = '<div class="alert alert-warning">';
			$output .= '<p>' . JText::_('COM_SPLMS_QUIZ_NOT_PREMITTED') .'</p>';
			$output .= '<a href="' . $this->courese->url . '">' . $this->courese->title .'</a>';
			$output .= '</div>';
			echo $output;

			return;	
		}

		//if already given quiz
		$this->quiz_results = $quiz_model->getQuizById( $user->id, $this->item->id );
		if(!empty($this->quiz_results)) {
			echo '<p class="alert alert-danger">' . JText::_('COM_SPLMS_ALREADY_GIVEN_QUIZ') . '</p>';
			return;	
		}

		$list_answers_decode 	= json_decode($this->item->list_answers);
		if ($list_answers_decode) {
			// Point table
			$qes_titles		= $list_answers_decode->qes_title;
			$ans_ones		= $list_answers_decode->ans_one;
			$ans_twos 		= $list_answers_decode->ans_two;
			$ans_threes		= $list_answers_decode->ans_three;
			$ans_fours 		= $list_answers_decode->ans_four;
			$right_anss		= $list_answers_decode->right_ans;
			
			$list_answers = array();
			foreach ($qes_titles as $id => $qes_title) {
				$list_answers[] = array(
					'qes_title' 	=> $qes_titles[$id],
					'ans_one' 		=> $ans_ones[$id],
					'ans_two' 		=> $ans_twos[$id],
					'ans_three' 	=> $ans_threes[$id],
					'ans_four' 		=> $ans_fours[$id],
					'right_ans' 	=> $right_anss[$id],
				);
			}

		} // END:: has list_answers

		?>
		
		<!-- Quiz Questions -->
		<script type="text/javascript">

			jQuery(function($) {

			$(".startQuiz").click(function(){
				$(document).find(".quizContainer").show();
				$(document).find(".before-start-quiz").hide();
			});

			var questions = [
			<?php foreach ($list_answers as $list_answer) {
				$qus_ans = '"' . trim($list_answer['ans_one']) . '", ' . '"' . trim($list_answer['ans_two']) . '", ' . '"' . trim($list_answer['ans_three']) . '", ' . '"' . trim($list_answer['ans_four']) . '", ';
			?>
			{
			    question: "<?php echo $list_answer['qes_title']; ?>",
			    choices: [<?php echo $qus_ans; ?>],
			    correctAnswer: <?php echo $list_answer['right_ans']; ?>
			},

			<?php } ?>

			];

			var currentQuestion = 0;
			var correctAnswers = 0;
			var quizOver = false;

			$(document).ready(function () {

			    // Display the first question
			    displayCurrentQuestion();
			    $(this).find(".quizMessage").hide();

			    // On clicking next, display the next question
			    $(this).find(".nextButton").on("click", function () {
			        if (!quizOver) {

			            value = $("input[type='radio']:checked").val();

			            if (value == undefined) {
			                $(document).find(".quizMessage").text("Please select an answer");
			                $(document).find(".quizMessage").show();
			            } else {
			                // TODO: Remove any message -> not sure if this is efficient to call this each time....
			                $(document).find(".quizMessage").hide();

			                if (value == questions[currentQuestion].correctAnswer) {
			                    correctAnswers++;
			                }

			                currentQuestion++; // Since we have already displayed the first question on DOM ready
			                if (currentQuestion < questions.length) {
			                    displayCurrentQuestion();
			                } else {
			                	insertScore();
			                    // Change the text in the next button to ask if user wants to play again
			                    $('.countdown-wrapper').hide();
			                    $(".quizContainer .nextButton").hide();
			                    //$(".quizContainer .nextButton").text("Start Again?");
			                    $(".quizContainer .nextButton").addClass("playagain");

							    $(".nextButton").on( "click", function() {	
									location.reload(true);
									//console.log('clicked');
								});

								quizOver = true;
			                }
			            }
			        } else { // quiz is over and clicked the next button (which now displays 'Play Again?'
			            quizOver = false;
			            //$(document).find(".nextButton").text("Next Question > ");
			            resetQuiz();
			            //displayCurrentQuestion();
			            hideScore();
			        }
			    });

			});

			// This displays the current question AND the choices
			function displayCurrentQuestion() {

			    //console.log("In display current Question");
			    var question = questions[currentQuestion].question;
			    var questionClass = $(document).find(".quizContainer .ques-ans-wrapper > .question");
			    var choiceList = $(document).find(".quizContainer .ques-ans-wrapper > .choiceList");
			    var numChoices = questions[currentQuestion].choices.length;

			    $(document).find(".lms-result-wrapper > .result").removeClass('active');
			    $(document).find(".quizContainer #countdown").show();
			    $(document).find(".nextButton").removeClass("playagain");
			    $(document).find(".quizContainer .ques-ans-wrapper").show();
				$(document).find(".quizContainer .ques-ans-wrapper").show();
				$('.countdown-wrapper').show();

			    // Set the questionClass text to the current question
			    $(questionClass).text(question);

			    // Remove all current <li> elements (if any)
			    $(choiceList).find("li").remove();

			    var choice;
			    for (i = 0; i < numChoices; i++) {
			        choice = questions[currentQuestion].choices[i];
			        $('<li><div class="radio"><label><input type="radio" value=' + i + ' name="dynradio" />' + choice + '</label></div></li>').appendTo(choiceList);
			    }
			}

			function resetQuiz() {
			    currentQuestion = 0;
			    correctAnswers = 0;
			    hideScore();
			}

			function displayScore() {
				$(document).find(".quizContainer .ques-ans-wrapper").hide();
			    $(document).find(".lms-result-wrapper > .result").text("You scored: " + correctAnswers + " out of: " + questions.length);
			    $(document).find(".lms-result-wrapper > .result").show().addClass('active');
			    $("#countdown").stop(true);
			}

			function displayError() {
				$(document).find(".quizContainer .ques-ans-wrapper").hide();
			    $(document).find(".lms-result-wrapper > .result").text("Some error occurred. Please try again.");
			    $(document).find(".lms-result-wrapper > .result").show().addClass('active');
			    $("#countdown").stop(true);
			}

			function hideScore() {
			    $(document).find(".lms-result-wrapper > .result").hide();
			}
			// Countdown
			$(".startQuiz").click(function(){ 
				// Count-down
				jQuery("#countdown").countDown({
					startNumber: <?php echo $this->item->duration; ?>,
					callBack: function(me) {
						//displayScore();
						if (!$(".lms-result-wrapper .result").hasClass("active")) {
							$(".lms-result-wrapper > .result").text("Times Up! Your score is: " + correctAnswers + " out of: " + questions.length);
							$(".quizContainer #countdown").hide();
							$(".quizContainer .countdown-wrapper").hide();
							$(".lms-result-wrapper > .result").show().addClass('active');
					    	$(".quizContainer .ques-ans-wrapper").hide();
					    	//$(".quizContainer .nextButton").text("Start Again?");
					    	$(".quizContainer .nextButton").hide();

					    	//resetQuiz();
					    	insertScore();
					    	
					    	quizOver = true;
					  //   	$(".nextButton").on( "click", function() {
							// 	location.reload(true);
							// 	//console.log('clicked');
							// });
						};
						//jQuery(me).text("All done! This is where you give the reward!").css("color", "#090");
					}
				});

			}) // END:: onclick start countdown


			//Ajax insert Data Form
			function insertScore() {
				jQuery(function($) {

				    //$('.sppb-ajaxt-contact-form').on('submit', function(event) {
				        //event.preventDefault();

				        // var $self   = $(this);
				        // var value   = $(this).serializeArray();
				        var request = {
				            'option' : 'com_splms',
				            'controller' : 'quizquestions',
				            'task' : 'quizquestions.submit_result',
				            'data'   : {
				            	user_id: <?php echo $userId; ?>,
				            	quiz_id: <?php echo $this->item->id; ?>,
				            	course_id: <?php echo $this->item->course_id; ?>,
				            	total_marks: questions.length,
				            	q_result: correctAnswers,
				            }
				        };

				        $.ajax({
				            type   : 'POST',
				            data   : request,
				            success: function (response) {
				            	var result = $.parseJSON(response);

				            	if(result){
									displayScore();
				            	} else {
				            		displayError();
				            	}
				            	
				            }
				        });

				        return false;
				       
				    //});
				});
			}

			});

			</script>
		<?php 

		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = $this->item->title;
        $cleanText              = $this->item->description;
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if ($this->item->image) {
        	$itemMeta['image']      = JURI::base() . $this->item->image;
        }
        SplmsHelper::itemMeta($itemMeta);
		parent::display($tpl);

	}


}