<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewLesson extends JViewLegacy{

	protected $item;
	protected $params;

	function display($tpl = null) {
		// Assign data to the view
		$this->item = $this->get('Item');
		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		//Joomla Component Helper & Get LMS Params
		jimport('joomla.application.component.helper');
		$params = JComponentHelper::getParams('com_splms');

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		// Load Models
		$courses_model 	= JModelLegacy::getInstance('Courses', 'SplmsModel');
		$teachers_model = JModelLegacy::getInstance('Teachers', 'SplmsModel');
		$lessons_model 	= JModelLegacy::getInstance('Lessons', 'SplmsModel');

		// Get User
		$this->user = JFactory::getUser();

		$this->lessons = $lessons_model->getLessons($this->item->course_id);
		$this->teacher = $teachers_model->getTeacher($this->item->teacher_id);
		$this->courese = $courses_model->getCourse($this->item->course_id);
		$this->isAuthorised = $courses_model->getIsbuycourse($this->user->id, $this->item->course_id);
		$this->has_complete_lesson = $lessons_model->hasCompleted($this->item->id, $this->user->id, 'lesson');

		// check authorised or free course
		if($this->item->lesson_type > 0 && !$this->isAuthorised && $this->courese->price > 0) {
			$output  = '<div class="alert alert-warning">';
			$output .= '<p>' . JText::_('COM_SPLMS_LESSON_NO_ACCESS') .'</p>';
			$output .= '<a href="' . $this->courese->url . '">' . $this->courese->title .'</a>';
			$output .= '</div>';

			echo $output;
			return;	
		}

		if ($this->item->video_url) {
			//Video Check host my URL
			$video = parse_url($this->item->video_url);
			if(isset($video['host']) && $video['host']){
				switch($video['host']) {
					case 'youtu.be':
					$this->id = trim($video['path'],'/');
					$this->src = '//www.youtube.com/embed/' . $this->id;
					break;

					case 'www.youtube.com':
					case 'youtube.com':
					parse_str($video['query'], $query);
					$this->id = $query['v'];
					$this->src = '//www.youtube.com/embed/' . $this->id;
					break;

					case 'vimeo.com':
					case 'www.vimeo.com':
					$this->id = trim($video['path'],'/');
					$this->src = "//player.vimeo.com/video/{$this->id}";
					break;
					default:
					$this->id = 'remote-host';
					$this->src = $this->item->video_url;
				}

				if ($this->id == 'remote-host') {

					$doc = JFactory::getDocument();
					$doc->addStylesheet( JURI::root(true) . '/components/com_splms/assets/css/video-player/tooltipster.css' );
					$doc->addStylesheet( JURI::root(true) . '/components/com_splms/assets/css/video-player/videoGallery_noPlaylist.css' );

					$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/video-player/captionator.js' );
					$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/video-player/jquery.tooltipster.js' );
					$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/video-player/jquery.videoGallery.min.js' );

					$this->video_thumb = (isset($this->item->vdo_thumb)) ? $this->video_thumb = JURI::root() . $this->item->vdo_thumb : b ;
					?>
					<script type="text/javascript">
						var hap_player;
						// LMS Player Settings
						var video_logo 				= "<?php echo JURI::root() . $params->get('videologo', ''); ?>";
						var video_logo_x_offset 	= "<?php echo $params->get('video_logo_x_offset'); ?>";
						var video_logo_y_offset		= "<?php echo $params->get('video_logo_y_offset'); ?>";
						var video_logo_tooltip_text = "<?php echo $params->get('video_logo_tooltip_text'); ?>";
						var video_logo_url 			= "<?php echo $params->get('video_logo_url'); ?>";
						jQuery(document).ready(function($) {
							var vplp_settings = {
								/* media_id: unique string for player identification (if multiple player instances were used, then strings need to be different!) */
								media_id:'player1',
								/* use_deeplink: true, false */
								use_deeplink:false,
								/*active_playlist: Active playlist to start with. If no deeplink is used, enter element 'id' attribute, or if deeplink is used enter element data-address attribute. */
								active_playlist:'playlist',
								/*active_item: Active video to start with. Enter number, -1 = no video loaded, 0 = first video, 1 = second video etc */
								active_item: 1,
								
								/*auto_hide_controls: auto hide player controls on mouse out: true/false. Defaults to false on mobile. */
								auto_hide_controls: false,
								/*controls_timeout: time after which controls and playlist hides in fullscreen if screen is inactive, in miliseconds. */
								controls_timeout:3000,
								default_volume: 0-1,

								default_volume:0.5,
								/*auto_play: true/false (defaults to false on mobile)*/
								auto_play: false,
								/*random_play: true/false */
								random_play:false,
								/* looping_on: on playlist end rewind to beginning (last item in playlist) */
								looping_on: false,
								/*auto_advance_to_next_video: true/false (use this to loop video) */
								auto_advance_to_next_video: false,
								/*auto_open_description: true/false  */
								auto_open_description:false,
								/*use_live_preview: true/false (if true, you need small videos for preview for local videos, otherwise thumbnails). Defaults to false on mobile. */
								use_live_preview: true,
								
								/* show_controls_in_advert: true/false (show controls while video advert plays)  */
								show_controls_in_advert:false,
								/* disable_seekbar_in_advert: true/false (disable seekbar while video advert plays)  */
								disable_seekbar_in_advert:false,
								/* show_skip_button_in_advert: true/false (show skip button while video advert plays)  */
								show_skip_button_in_advert: false,
								advert_skip_btn_text:'SKIP AD >',
								advert_skip_video_text:'You can skip to video in',
								
								/* context_menu_type: disabled, custom, default */
								context_menu_type:'custom',
								/* context_menu_text: Custom text link in context menu. Leave empty for none.  */
								context_menu_text:'',
								/* context_menu_link: url link, leave empty for none  */
								context_menu_link:'',
								/* context_menu_target: _blank/_parent (opens in new/same window)  */
								context_menu_target:'',
								
								logo_path: video_logo,
								logo_position: 'tl',
								logo_x_offset: video_logo_x_offset,
								logo_y_offset: video_logo_y_offset,
								logo_tooltip_text: video_logo_tooltip_text,
								logo_url: video_logo_url,
								logo_target: '_blank',
								
								/*aspect_ratio: video aspect ratio (0 = original, 1 = fit inside, 2 = fit outside). Defaults to 1 on mobile! */
								aspect_ratio: 2,
								/*playlist_orientation: vertical/horizontal  */
								playlist_orientation:'vertical',
								/*playlist_type: list/wall/wall_popup */
								playlist_type:'list',
								show_playlist:false,
								/*scroll_type: scroll/buttons  */
								scroll_type:'buttons',
								/*wall_path: folder replacement path for the wall data */
								wall_path:'/wall/',
								yt_app_id:'AIzaSyA9jm0xJOYX0KD1nuijTbhO4OFC4gYQnb0',
								use_share: false,
								/*fs_app_id: facebook application id (if you use facebook share, https://developers.facebook.com/apps) */
								fs_app_id:'',
								/*dropdown_id: id attribute of the element with holds the dropdown */
								dropdown_id:'#hap_drop',
								/*playlistList: dom element which holds list of playlists */
								playlist_list:'#playlist_list',
								buttons_url: {thumbnailPreloaderUrl: 'data/loading.gif'},
								/* auto_reuse_mail_for_download: true/false. download backup for ios, save email after client first enters email address and auto send all emails to the same address */
								auto_reuse_mail_for_download: false,
								use_tooltips:true,
								tooltip_titles: {
								/* tooltip titles */
								remove: 'Remove',/* remove button */
								detail: 'View detail',/* lightbox button */
								link: 'External link',/* external link button */
								action: 'External action'}/* empty action button */
							};
							
							hap_player = $('#MainWrapper').videoGallery(vplp_settings);
						});
					</script>
					<?php
				}
			}
		} // has video url
		
		if (isset($this->teacher) && $this->teacher) {
			$this->teacher_description = strip_tags($this->teacher->description);
			if (strlen($this->teacher_description) > 400) {
		    // truncate string
				$descriptionCut = substr($this->teacher_description, 0, 340);
		    // make sure it ends in a word so assassinate doesn't become ass...
				$this->teacher_description = substr($descriptionCut, 0, strrpos($descriptionCut, ' ')).'...';
		    // Show Desription
				$this->teacher_description = $this->teacher_description;
			}else{
				$this->teacher_description = $this->teacher_description;
			}
		}

		// Generate menu title
		// if ($this->item->title) {
		// 	$menu->title = $this->item->title;
		// }

		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = $this->item->title;
        $cleanText              = $this->item->description;
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if ($this->item->vdo_thumb) {
        	$itemMeta['image']      = JURI::base() . $this->item->vdo_thumb;
        }
		SplmsHelper::itemMeta($itemMeta);
		
		parent::display($tpl);
	}

}