<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

$doc = JFactory::getDocument();
$doc->addScriptdeclaration('var splms_url="'. JURI::base() .'index.php?option=com_splms";');

?>

<div id="splms" class="splms splms-lessons splms-lesson-details">

	<?php if ($this->item->video_url) { ?>
		<div class="lesson-video">			
			<div id="splms-lesson-video-<?php echo $this->id; ?>" class="lesson-video">
				<?php if (isset($this->id) && $this->id == 'remote-host') { ?>
	                <!-- player markup -->
			        <div id="MainWrapper"></div>
			        <div id="playlist_list">
			            <!-- local tracks -->
			            <div id="playlist" data-address="playlist">
			                <div class="playlistNonSelected" data-address="local1" data-type="local" data-mp4="<?php echo $this->src; ?>" data-preview="<?php echo JURI::root() . $this->item->vdo_thumb; ?>" data-thumb="<?php echo $this->video_thumb; ?>">
			                </div>
			            </div>
			        </div>
				<?php } elseif(isset($this->id)) { ?>
					<div class="embed-responsive embed-responsive-16by9">
						<iframe src="<?php echo $this->src; ?>" width="100%" height="400" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
					</div>
				<?php } elseif($this->item->vdo_thumb) { ?>
					<img src="<?php echo $this->item->vdo_thumb; ?>" class="splms-img-responsive img-thumbnail" alt="<?php echo $this->item->title; ?>">
				<?php } ?>
			</div>
		</div>
	<?php } ?>

	<div class="splms-lesson-description item-content">
		<h2><?php echo $this->item->title; ?></h2>
		<div class="splms-lesson-description">
			<?php echo $this->item->description; ?>
		</div>
	</div>

	<?php if (isset($this->item->attachment) && $this->item->attachment) { ?>
	<div class="item-content splms-lesson-attachment-wrapper">
		<a class="btn btn-default attachment-button" target="_blank" href="<?php echo JUri::root(). $this->item->attachment; ?>">
			<?php echo JText::_('COM_SPLMS_LESSON_DOWNLOAD_ATTACHMENT')?>
		</a>
	</div>
	<?php } ?>
	
	<!-- Has lesson -->
	<?php if(!empty($this->lessons) && count($this->lessons) && $this->lessons) { ?>
	<!-- start course-lessons  -->
	<div class="course-lessons">
		<h3><?php echo JText::_('COM_SPLMS_LESOSNS_LIST'); ?></h3>
		<ul class="lessons list-unstyled">
			<?php foreach ($this->lessons as $lesson) { ?>
				<?php $active_lesson = ( $this->item->id == $lesson->id ) ? ' active': ''; ?>
				<?php if ($lesson->lesson_type == 0 || $this->isAuthorised != '' || $this->courese->price == 0) { ?>
					<li class="lesson<?php echo $active_lesson; ?>">
						<span>
							<a href="<?php echo $lesson->lesson_url; ?>">
								<?php echo $lesson->title; ?>
							</a>
						</span>
						<span class="pull-right">
							<?php echo JText::_('COM_SPLMS_COMMON_DURATION') . JText::_(': '); ?>
							<?php echo $lesson->video_duration; ?>
						</span>
					</li>
				<?php } else {?>
					<li class="lesson splms-lesson-unauthorised">
						<span>
							<i class="splms-icon-lock"></i>
							<?php echo $lesson->title; ?>
						</span>
						<span class="pull-right">
							<?php echo JText::_('COM_SPLMS_COMMON_DURATION') . ': '; ?>
							<?php echo $lesson->video_duration; ?>
						</span>
					</li>
				<?php } // end else ?>

			<?php } // END:: foreach ?>
		</ul>
	</div> <!-- end course-lessons -->
	<?php } // END:: has lesson ?>

	<?php if(isset($this->teacher) && $this->teacher){ ?>
	<div class="splms-lesson-teacher-wrapper">
		<h2 class="splms-lesson-teacher-info-title"><?php echo JText::_('COM_SPLMS_COMMON_TEACHER_INFO'); ?></h2>
		<div class="splms-row">
			<div class="splms-teacher-img-wraper splms-col-sm-4 splms-col-md-3">
				<div class="splms-teacher-thumb">
					<img src="<?php echo $this->teacher->image; ?>" class="splms-img-responsive img-thumbnail" alt="<?php echo $this->teacher->title; ?>">
				</div>
			</div>
			<div class="splms-teacher-info-wraper splms-col-sm-8 splms-col-md-9">
				<h3 class="splms-lesson-teacher-name">
                	<a href="<?php echo $this->teacher->url; ?>">
                	<?php echo $this->teacher->title;?>
                	</a>
                </h3>
				
		        <ul class="teachers-details list-unstyled">
					<?php if (isset($this->teacher->specialist_in) && $this->teacher->specialist_in) {?>
						<li>
							<?php echo JText::_('COM_SPLMS_COMMON_SPECIALIST_IN'). ': '; ?>
							<?php  $this->teacher->specialist_in; ?>
						</li>
					<?php } if (isset($this->teacher->experience) && $this->teacher->experience) {?>
						<li> 
							<?php echo JText::_('COM_SPLMS_COMMON_EXPERIENCE'). ': '; ?> 
							<?php echo $this->teacher->experience; ?>
						</li>
		            <?php } if (isset($this->teacher->website) && $this->teacher->website) {?>
		            <li>
		            	<?php echo JText::_('COM_SPLMS_COMMON_WEBSITE'). ': '; ?>
		            	<a href="<?php echo $this->teacher->website;?>">
		            		<?php echo $this->teacher->website; ?>
		            	</a>
		            </li>
		            <?php } ?>

		            <li class="splms-teacher-social-icon">
		            	<ul class="list-unstyled list-inline splms-social-icon-list">
		            		<?php if (isset($this->teacher->social_facebook) && $this->teacher->social_facebook) {?>
		            		<li>
		            			<a href="<?php echo $this->teacher->social_facebook;?>">
		            				<span class="splms-icon-facebook"></span>
		            			</a>
		            		</li>
		            		<?php } ?>

		            		<?php if (isset($this->teacher->social_linkedin) && $this->teacher->social_linkedin) {?>
		            		<li>
		            			<a href="<?php echo $this->teacher->social_linkedin;?>">
		            				<span class="splms-icon-linkedin"></span>
		            			</a>
		            		</li>
		            		<?php } ?>

		            		<?php if (isset($this->teacher->social_twitter) && $this->teacher->social_twitter) {?>
		            		<li>
		            			<a href="<?php echo $this->teacher->social_twitter;?>">
		            				<span class="splms-icon-twitter"></span>
		            			</a>
		            		</li>
		            		<?php } ?>

		            		<?php if (isset($this->teacher->social_gplus) && $this->teacher->social_gplus) {?>
		            		<li>
		            			<a href="<?php echo $this->teacher->social_gplus;?>">
		            				<span class="splms-icon-google-plus"></span>
		            			</a>
		            		</li>
		            		<?php } ?>
		            	</ul>
		            </li>
					<?php if($this->teacher_description) { ?>
		            <li>
		            	<p>
		            		<?php echo $this->teacher_description; ?>
		            	</p>
		            </li>
					<?php } ?>
		        </ul>
			</div> <!-- /.splms-teacher-info-wraper -->
		</div> <!-- /.splms-row -->
	</div> <!-- /.splms-lesson-teacher-wrapper -->
	<?php } // has teacher ?>
	
	<div class="splms-lesson-completed-lesson-wrapper">
		<?php if($this->user->guest) {
			$link =  base64_encode(JUri::getInstance()->toString());
			$login_link = JRoute::_('index.php?option=com_users&view=login'. SplmsHelper::getItemid('login') .'&return=' . $link);
		?>
			<a class="btn btn-primary" href="<?php echo $login_link; ?>">
				<?php echo JText::_('COM_SPLMS_LOGIN_TO_COMPLETE'); ?>
			</a>
		<?php } elseif(!$this->has_complete_lesson) {?>
			<form id="splms-completed-item-form">
				<input type="hidden" name="user_id" value="<?php echo $this->user->id; ?>">
				<input type="hidden" name="item_id" value="<?php echo $this->item->id; ?>">
				<input type="hidden" name="item_type" value="lesson">
				<a class="btn btn-primary" id="splms-completed-item" href="#">
					<?php echo JText::_('COM_SPLMS_LESSON_COMPLETE'); ?>
				</a>
			</form>
		<?php } else { ?>
			<a class="btn btn-primary" id="splms-completed-item" href="#">
				<?php echo JText::_('COM_SPLMS_LESSON_COMPLETED'); ?>
			</a>
		<?php } ?>
	</div>

</div> <!-- /#splms -->