<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewCoursescategory extends JViewLegacy{

	protected $item;
	protected $params;

	function display($tpl = null) {
		// Assign data to the view
		$this->item = $this->get('Item');
		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		//get Component Params
		jimport('joomla.application.component.helper');
		$this->params = JComponentHelper::getParams('com_splms');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		// Load courses & lesson Model
		$model = JModelLegacy::getInstance( 'Coursescategories', 'SplmsModel' );
		$courses_model = JModelLegacy::getInstance('Courses', 'SplmsModel');
		$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

		// Add Script
		$doc = JFactory::getDocument();
		$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/matchheight.js' );

		//Get Currency
		$currency = explode(':', $this->params->get('currency', 'USD:$'));
		$this->currency =  $currency[1];

		// Get courses by Category
		$this->category_items = $model->getCoursesByCategory($this->item->id);

		// Get image thumb
		$this->thumb_size = strtolower($this->params->get('course_thumbnail', '480X300'));

		if (!count($this->category_items)) {
			echo '<p class="alert alert-warning">' . JText::_('COM_SPLMS_NO_ITEMS_FOUND') . '</p>';
			return;
		}

		foreach ($this->category_items as &$this->category_item) {
			// Generate URL
			$this->category_item->url = JRoute::_('index.php?option=com_splms&view=course&id=' . $this->category_item->id . ':' . $this->category_item->alias . SplmsHelper::getItemid('course')); 
			// Get course teachers
			$this->category_item->teachers = $courses_model->getCourseTeachers( $this->category_item->id );
			// Get course lessons
			$this->category_item->lessons  = $lessons_model->getLessons( $this->category_item->id );
			// Count course lesosns Attachments
			$this->category_item->total_attachments = array();
			foreach ($this->category_item->lessons as $lesson) {
				if ($lesson->attachment) {
					$this->category_item->total_attachments[] = $lesson->attachment;
				}
			}
			// Get Prices
			if ($this->category_item->price == 0) {
				$this->category_item->c_price = JText::_('COM_SPLMS_FREE');
			} else {
				$this->category_item->c_price = SplmsHelper::generateCurrency($this->category_item->price, $this->category_item->sale_price);
			}
		}

		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = $this->item->title;
        $cleanText              = $this->item->description;
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if ($this->item->image) {
        	$itemMeta['image']      = JURI::base() . $this->item->image;
        }
        SplmsHelper::itemMeta($itemMeta);
		
		parent::display($tpl);
	}

}