<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewCourse extends JViewLegacy{
	
	protected $item;
	protected $params;

	function display($tpl = null) {
		// Assign data to the view
		$this->item = $this->get('Item');
		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		// legacy support
		$this->item->splms_coursescategory_id 	= $this->item->coursecategory_id;
		$this->item->splms_course_id 			= $this->item->id;

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		$model = JModelLegacy::getInstance( 'courses', 'SplmsModel' );
		$lessons_model = JModelLegacy::getInstance( 'Lessons', 'SplmsModel' );

		//Joomla Component Helper & Get LMS Params
		jimport('joomla.application.component.helper');
		$this->params = JComponentHelper::getParams('com_splms');
		// Get image thumb
		$this->thumb_size = strtolower($this->params->get('course_thumbnail', '480X300'));
		$this->show_related_courses = $this->params->get('related_course', 0);
		$this->review 	= $this->params->get('review', false);

		// Add Script
		$doc = JFactory::getDocument();
		$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/splms.js' );
		$doc->addScriptdeclaration('var splms_url="' . JURI::base() . 'index.php?option=com_splms";');

		$this->user = JFactory::getUser();
		$this->lessons      = $lessons_model->getLessons($this->item->id);
		$this->quizzes      = $model->getQuizzes($this->item->id);
		$this->freeLesson   = $lessons_model->getCourseFreeLesson($this->item->id);
		$this->isAuthorised = $model->getIsbuycourse($this->user->id, $this->item->id);

		//Get course teacher
		$this->teachers = $model->getCourseTeachers( $this->item->id );
		foreach ($this->teachers as $this->teacher) {
			$speacility_decodes = (array) json_decode($this->teacher->specialist_in);
			if ($speacility_decodes) {
				$this->teacher->specialist_in = array ();
				$i = 0;
				foreach ($speacility_decodes as $key => $speacility_decode) {
					if ($speacility_decode->specialist_text) {
						$this->teacher->specialist_in[$i] = $speacility_decode->specialist_text;
						$i ++;
					}
				}
				$this->teacher->specialist_in = implode(', ', $this->teacher->specialist_in);
			}
		}

		// Lessons
		$sum_durations = 0;
		foreach ($this->lessons as $this->lesson) {
			$exploded_times = explode(':', $this->lesson->video_duration);
			if(count($exploded_times)> 1) {
				$duration_seconds = ($exploded_times[0] * 60) + $exploded_times[1]; 
				$sum_durations += $duration_seconds;
			}
		}
		$this->total_durations = explode(':', SplmsHelper::time_from_seconds($sum_durations));
		$this->total_teachers = count($this->teachers);
		$this->total_lessons  = count($this->lessons);
		$this->total_enrolled = $model->getEnrolled($this->item->id);

		//schedule days
		if (isset($this->item->course_schedules) && !empty($this->item->course_schedules) && !is_array($this->item->course_schedules) && SplmsHelper::isJson($this->item->course_schedules)) {
			$this->item->course_schedules = json_decode($this->item->course_schedules, TRUE);
		}

		$this->schedule_days_lang = array(
			JTEXT::_('COM_SPLMS_DAY_SUNDAY'),
			JTEXT::_('COM_SPLMS_DAY_MONDAY'),
			JTEXT::_('COM_SPLMS_DAY_TUESDAY'),
			JTEXT::_('COM_SPLMS_DAY_WEDNESDAY'),
			JTEXT::_('COM_SPLMS_DAY_THURSDAY'),
			JTEXT::_('COM_SPLMS_DAY_FRIDAY'),
			JTEXT::_('COM_SPLMS_DAY_SATURDAY')
		);
		
		$this->schedule_days = array(
			'sunday', 
			'monday', 
			'tuesday', 
			'wednesday', 
			'thursday', 
			'friday', 
			'saturday'
		);

		$this->hasdays = array();
		if (is_array($this->item->course_schedules) && $this->item->course_schedules) {
			foreach ($this->item->course_schedules as $course_schedule) {
				$this->hasdays [] = $course_schedule['day'];
			}
		}

		// course info
		if (isset($this->item->course_infos) && !empty($this->item->course_infos) && !is_array($this->item->course_infos) && SplmsHelper::isJson($this->item->course_infos)) {
			$this->item->course_infos = json_decode($this->item->course_infos, TRUE);
		}

		// Related courses
		$this->related_courses = $model->getRelatedCourses($this->item->title, $this->item->id, $this->item->coursecategory_id ,3);
		foreach ($this->related_courses as &$this->related_course) {
			// image thumb size
			$filename = basename($this->related_course->image);
			$path = JPATH_BASE .'/'. dirname($this->related_course->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $this->thumb_size . '.' . JFile::getExt($filename);
			$src = JURI::base(true) . '/' . dirname($this->related_course->image) . '/thumbs/' . JFile::stripExt($filename) . '_' . $this->thumb_size . '.' . JFile::getExt($filename);

			if(JFile::exists($path)) {
				$this->related_course->thumb = $src;
			} else {
				$this->related_course->thumb = JURI::root() . $this->related_course->image;
			}
		}

		// review
		$this->myReview = $model->getMyReview($this->item->id);
		$this->reviews 	= $model->getReviews($this->item->id);
		$this->ratings 	= $model->getRatings($this->item->id);

		$this->showLoadMore = false;
		if($model->getTotalReviews($this->item->id) > count($this->reviews)) {
			$this->showLoadMore = true;
		}

		// Get Currency
		$this->currency = explode(':', $this->params->get('currency', 'USD:$'));

		$this->coursePrice='';
		if ($this->item->price == 0) {
			$this->coursePrice = JText::_('COM_SPLMS_FREE');
		}else{
			$this->coursePrice = SplmsHelper::generateCurrency($this->item->price, $this->item->sale_price);
		}

		// Video Player
		if ( (isset($this->freeLesson[0]->video_url) && $this->freeLesson[0]->video_url) || $this->item->video_url ) {

			//Video Check host URL
			$this->video_link = ($this->item->video_url) ? $this->item->video_url : $this->freeLesson[0]->video_url;
			$video = parse_url($this->video_link);

			switch($video['host']) {
				case 'youtu.be':
					$this->id = trim($video['path'],'/');
					$this->src = '//www.youtube.com/embed/' . $this->id;
				break;

				case 'www.youtube.com':
				case 'youtube.com':
					parse_str($video['query'], $query);
					$this->id = $query['v'];
					$this->src = '//www.youtube.com/embed/' . $this->id;
				break;

				case 'vimeo.com':
				case 'www.vimeo.com':
					$this->id = trim($video['path'],'/');
					$this->src = "//player.vimeo.com/video/{$this->id}";
				break;
				default:
					$this->id = 'remote-host';
					$this->src = $this->freeLesson[0]->video_url;
			}

			if ($this->id == 'remote-host') {
				$doc = JFactory::getDocument();

				// Load Player CSS files
				$doc->addStylesheet( JURI::root(true) . '/components/com_splms/assets/css/video-player/tooltipster.css' );
				$doc->addStylesheet( JURI::root(true) . '/components/com_splms/assets/css/video-player/videoGallery_noPlaylist.css' );

				// Load JS files
				$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/video-player/captionator.js' );
				$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/video-player/jquery.tooltipster.js' );
				$doc->addScript( JURI::root(true) . '/components/com_splms/assets/js/video-player/jquery.videoGallery.min.js' );

				?>
				<script type="text/javascript">
					var hap_player;
					// LMS Player Settings
					var video_logo 				= "<?php echo JURI::root() . $this->params->get('videologo'); ?>";
					var video_logo_x_offset 	= "<?php echo $this->params->get('video_logo_x_offset'); ?>";
					var video_logo_y_offset		= "<?php echo $this->params->get('video_logo_y_offset'); ?>";
					var video_logo_tooltip_text = "<?php echo $this->params->get('video_logo_tooltip_text'); ?>";
					var video_logo_url 			= "<?php echo $this->params->get('video_logo_url'); ?>";
					jQuery(document).ready(function($) {
						var vplp_settings = {
							/* media_id: unique string for player identification (if multiple player instances were used, then strings need to be different!) */
							media_id:'player1',
							/* use_deeplink: true, false */
							use_deeplink:false,
							/*active_playlist: Active playlist to start with. If no deeplink is used, enter element 'id' attribute, or if deeplink is used enter element data-address attribute. */
							active_playlist:'playlist',
							/*active_item: Active video to start with. Enter number, -1 = no video loaded, 0 = first video, 1 = second video etc */
							active_item: 1,

							/*auto_hide_controls: auto hide player controls on mouse out: true/false. Defaults to false on mobile. */
							auto_hide_controls: false,
							/*controls_timeout: time after which controls and playlist hides in fullscreen if screen is inactive, in miliseconds. */
							controls_timeout:3000,
							default_volume: 0-1,

							default_volume:0.5,
							/*auto_play: true/false (defaults to false on mobile)*/
							auto_play: false,
							/*random_play: true/false */
							random_play:false,
							/* looping_on: on playlist end rewind to beginning (last item in playlist) */
							looping_on: false,
							/*auto_advance_to_next_video: true/false (use this to loop video) */
							auto_advance_to_next_video: false,
							/*auto_open_description: true/false  */
							auto_open_description:false,
							/*use_live_preview: true/false (if true, you need small videos for preview for local videos, otherwise thumbnails). Defaults to false on mobile. */
							use_live_preview: true,

							/* show_controls_in_advert: true/false (show controls while video advert plays)  */
							show_controls_in_advert:false,
							/* disable_seekbar_in_advert: true/false (disable seekbar while video advert plays)  */
							disable_seekbar_in_advert:false,
							/* show_skip_button_in_advert: true/false (show skip button while video advert plays)  */
							show_skip_button_in_advert: false,
							advert_skip_btn_text:'SKIP AD >',
							advert_skip_video_text:'You can skip to video in',

							/* context_menu_type: disabled, custom, default */
							context_menu_type:'custom',
							/* context_menu_text: Custom text link in context menu. Leave empty for none.  */
							context_menu_text:'',
							/* context_menu_link: url link, leave empty for none  */
							context_menu_link:'',
							/* context_menu_target: _blank/_parent (opens in new/same window)  */
							context_menu_target:'',

							logo_path: video_logo,
						    logo_position: 'tl',
						    logo_x_offset: video_logo_x_offset,
						    logo_y_offset: video_logo_y_offset,
						    logo_tooltip_text: video_logo_tooltip_text,
						    logo_url: video_logo_url,
						    logo_target: '_blank',

							/*aspect_ratio: video aspect ratio (0 = original, 1 = fit inside, 2 = fit outside). Defaults to 1 on mobile! */
							aspect_ratio: 2,
							/*playlist_orientation: vertical/horizontal  */
							playlist_orientation:'vertical',
							/*playlist_type: list/wall/wall_popup */
							playlist_type:'list',
							show_playlist:false,
							/*scroll_type: scroll/buttons  */
							scroll_type:'buttons',
							/*wall_path: folder replacement path for the wall data */
							wall_path:'/wall/',
							yt_app_id:'AIzaSyA9jm0xJOYX0KD1nuijTbhO4OFC4gYQnb0',
							use_share: false,
							/*fs_app_id: facebook application id (if you use facebook share, https://developers.facebook.com/apps) */
							fs_app_id:'',
							/*dropdown_id: id attribute of the element with holds the dropdown */
							dropdown_id:'#hap_drop',
							/*playlistList: dom element which holds list of playlists */
							playlist_list:'#playlist_list',
							buttons_url: {thumbnailPreloaderUrl: 'data/loading.gif'},
							/* auto_reuse_mail_for_download: true/false. download backup for ios, save email after client first enters email address and auto send all emails to the same address */
							auto_reuse_mail_for_download: false,
							use_tooltips:true,
							tooltip_titles: {
							   /* tooltip titles */
							   remove: 'Remove',/* remove button */
							   detail: 'View detail',/* lightbox button */
							   link: 'External link',/* external link button */
							   action: 'External action'}/* empty action button */
						};

						hap_player = $('#MainWrapper').videoGallery(vplp_settings);
					});
		        </script>
		<?php
			} // has video URL
		}

		// Generate menu title
		// if (isset($this->item->title) && $this->item->title ) {
		// 	$menu->title = $this->item->title;
		// }

		//Generate Item Meta
        $itemMeta               = array();
        $itemMeta['title']      = $this->item->title;
        $cleanText              = $this->item->description;
        $itemMeta['metadesc']   = JHtml::_('string.truncate', JFilterOutput::cleanText($cleanText), 155);
        if ($this->item->image) {
        	$itemMeta['image']      = JURI::base() . $this->item->image;
        }
        SplmsHelper::itemMeta($itemMeta);
		parent::display($tpl);
	}
	
}
