<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsViewCart extends JViewLegacy {

	public function onAdd($tpl = null){
		return $this->onDisplay();
	}

	protected $items;
	protected $params;
	protected $layout_type;

	function display($tpl = null) {
		// Assign data to the view
		$this->items = $this->get('items');
		$this->pagination	= $this->get('Pagination');

		$app = JFactory::getApplication();
		$this->params = $app->getParams();
		$menus = JFactory::getApplication()->getMenu();
		$menu = $menus->getActive();

		// Load Lessons model
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_splms/models');
		
		// Check for errors.
		if ($errors = $this->get('Errors') && count($errors = $this->get('Errors'))) {
			JLog::add(implode('<br />', $errors), JLog::WARNING, 'jerror');
			return false;
		}

		// Load Models
		$courses_model = JModelLegacy::getInstance('Courses', 'SplmsModel');

		jimport('joomla.application.component.helper');
		$this->params = JComponentHelper::getParams('com_splms');
		$this->currency = explode(':', $this->params->get('currency', "USD:$"));
		$this->payment_method = $this->params->get('payment_method', array('direct'));
		$this->bank_info = $this->params->get('bank_info', '');

		$session = JFactory::getSession();
		// Get input cookie object
		$cookie  = JFactory::getApplication()->input->cookie;
		//$this->orders_info = $session->get('splms_orders');
		//$this->orders_info = $cookie->get($name = 'splms_orders', $default = null);

		// $cookie_items = unserialize(base64_decode($cookie->get('splmsOrders')));
		// $cookie_items = (!is_array($cookie_items) && !$cookie_items) ? array() : $cookie_items;

		$this->orders_info = unserialize( base64_decode( $cookie->get('splmsOrders', json_encode(array())) ) );
		$this->orders_info = (!is_array($this->orders_info) && !$this->orders_info) ? array() : $this->orders_info;

		$session = JFactory::getSession();
		$input = JFactory::getApplication()->input;
		//$orders = $session->get('splms_orders');
		$orders = unserialize( base64_decode( $cookie->get('splmsOrders',  json_encode(array()) ) ) );
		$orders = (!is_array($orders) && !$orders) ? array() : $orders;
		$to_removed_course_id = $input->get('remove', '', 'INT');

		// order system
		if(!empty($orders)) {
			foreach ($orders as &$order) {
				$order['info'] = $courses_model->getCourse($order['product_id']);
				if (isset($order['info']->sale_price) && $order['info']->sale_price && $order['info']->sale_price != 0) {
					$order['price'] = $order['info']->sale_price;
				}
			}
		} else {
			$this->carts = array();
		}

		if(!empty($orders) && $to_removed_course_id) {
			foreach ($orders as $key => $corder) {
				if ($corder['product_id'] == $to_removed_course_id) {
					unset($orders[$key]);
				}
			}
			//$session->set( 'splms_orders', $orders);
			$cookie->set('splmsOrders', base64_encode(serialize($orders)), $expire = 0, JUri::base(true));
			$this->carts = $orders;
		}

		$this->carts = $orders;

		$this->user = JFactory::getUser();
		$app = JFactory::getApplication();

		$this->notify_url 	= JURI::base() . 'index.php?option=com_splms&task=payment.notify';
		$this->return_success = JURI::base() . 'index.php?option=com_splms&task=payment.success';
		$this->return_cencel  = JURI::base() . 'index.php?option=com_splms&task=payment.paymencancel';

		$this->direct_payment = JURI::base() . 'index.php?option=com_splms&task=payment.direactPayment&pm=direct';
		$this->bank_payment = JURI::base() . 'index.php?option=com_splms&task=payment.direactPayment&pm=bank';
		

		$this->layout_type = str_replace('_', '-', $this->params->get('layout_type', 'default'));

		
		parent::display($tpl);
	}

}
