<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsRouter extends JComponentRouterView {

	protected $noIDs = false;

	public function __construct($app = null, $menu = null){

		$params = JComponentHelper::getParams('com_splms');
		$this->noIDs = (bool) $params->get('sef_ids', 1);

		// Register single views
		$this->registerView(new JComponentRouterViewconfiguration('purchases'));
		$this->registerView(new JComponentRouterViewconfiguration('cart'));
		$this->registerView(new JComponentRouterViewconfiguration('certificate'));
		
		// course categories
		$coursescategories = new JComponentRouterViewconfiguration('coursescategories');
		$this->registerView($coursescategories);
		$coursescategory = new JComponentRouterViewconfiguration('coursescategory');
		$coursescategory->setKey('id')->setParent($coursescategories);
		$this->registerView($coursescategory);

		// courses
		$courses = new JComponentRouterViewconfiguration('courses');
		$this->registerView($courses);
		$course = new JComponentRouterViewconfiguration('course');
		$course->setKey('id')->setParent($courses);
		$this->registerView($course);

		// teachers
		$teachers = new JComponentRouterViewconfiguration('teachers');
		$this->registerView($teachers);
		$teacher = new JComponentRouterViewconfiguration('teacher');
		$teacher->setKey('id')->setParent($teachers);
		$this->registerView($teacher);

		// eventcategories
		$eventcategories = new JComponentRouterViewconfiguration('eventcategories');
		$this->registerView($eventcategories);
		$eventcategory = new JComponentRouterViewconfiguration('eventcategory');
		$eventcategory->setKey('id')->setParent($eventcategories);
		$this->registerView($eventcategory);

		// events
		$events = new JComponentRouterViewconfiguration('events');
		$this->registerView($events);
		$event = new JComponentRouterViewconfiguration('event');
		$event->setKey('id')->setParent($events);
		$this->registerView($event);

		// speakers
		$speakers = new JComponentRouterViewconfiguration('speakers');
		$this->registerView($speakers);
		$speaker = new JComponentRouterViewconfiguration('speaker');
		$speaker->setKey('id')->setParent($speakers);
		$this->registerView($speaker);

		// quizquestions
		$quizquestions = new JComponentRouterViewconfiguration('quizquestions');
		$this->registerView($quizquestions);
		$quizquestion = new JComponentRouterViewconfiguration('quizquestion');
		$quizquestion->setKey('id')->setParent($quizquestions);
		$this->registerView($quizquestion);

		// certificates
		$certificates = new JComponentRouterViewconfiguration('certificates');
		$this->registerView($certificates);
		$certificate = new JComponentRouterViewconfiguration('certificate');
		$certificate->setKey('id')->setParent($certificates);
		$this->registerView($certificate);


		// generate rules
		parent::__construct($app, $menu);
			
		$this->attachRule(new JComponentRouterRulesNomenu($this));

		if ($params->get('sef_advanced', 0)) {
			$this->attachRule(new JComponentRouterRulesMenu($this));
			$this->attachRule(new JComponentRouterRulesStandard($this));
		} else {
			JLoader::register('SplmsRouterRulesLegacy', __DIR__ . '/helpers/legacyrouter.php');
			$this->attachRule(new SplmsRouterRulesLegacy($this));
		}
	}

	// Coursescategory
	public function getCoursescategorySegment($id, $query) {

		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_coursescategories'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		list($void, $segment) = explode(':', $id, 2);
		return array($void => $segment);
	}

	public function getCoursescategoryId($segment, $query) {
		$db = JFactory::getDbo();
		$dbquery = $db->getQuery(true);
		$dbquery->select($dbquery->qn('id'))
			->from($dbquery->qn('#__splms_coursescategories'))
			->where('alias = ' . $dbquery->q($segment));
		$db->setQuery($dbquery);

		return (int) $db->loadResult();
	}

	public function getCoursesSegment($id, $query) {
		$category = JCategories::getInstance($this->getName())->get($id);

		if ($category) {
			$path = array_reverse($category->getPath(), true);
			$path[0] = '1:root';

			if ($this->noIDs) {
				foreach ($path as &$segment) {
					list($id, $segment) = explode(':', $segment, 2);
				}
			}

			return $path;
		}

		return array();
	}

	public function getCoursesId($segment, $query) {
		if (isset($query['id'])) {
			$category = JCategories::getInstance($this->getName())->get($query['id']);

			foreach ($category->getChildren() as $child) {
				if ($this->noIDs) {
					if ($child->alias == $segment) {
						return $child->id;
					}
				} else {
					if ($child->id == (int) $segment) {
						return $child->id;
					}
				}
			}
		}

		return false;
	}

	public function getCourseSegment($id, $query) {
		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_courses'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		if ($this->noIDs) {
			list($void, $segment) = explode(':', $id, 2);
			return array($void => $segment);
		}
		return array((int) $id => $id);
	}
	public function getCourseId($segment, $query) {

		if ($this->noIDs) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__splms_courses'))
				->where('alias = ' . $dbquery->q($segment));
			$db->setQuery($dbquery);
			return (int) $db->loadResult();
		}
		return (int) $segment;
	}

	// Teacher
	public function getTeacherSegment($id, $query) {
		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_teachers'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		if ($this->noIDs) {
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}
		return array((int) $id => $id);
	}
	public function getTeacherId($segment, $query) {

		if ($this->noIDs) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__splms_teachers'))
				->where('alias = ' . $dbquery->q($segment));
			$db->setQuery($dbquery);
			return (int) $db->loadResult();
		}
		return (int) $segment;
	}

	// Eventcategories
	public function getEventcategorySegment($id, $query) {
		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_eventcategories'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		if ($this->noIDs) {
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}
		return array((int) $id => $id);
	}
	public function getEventcategoryId($segment, $query) {

		if ($this->noIDs) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__splms_eventcategories'))
				->where('alias = ' . $dbquery->q($segment));
			$db->setQuery($dbquery);
			return (int) $db->loadResult();
		}
		return (int) $segment;
	}

	// event
	public function getEventSegment($id, $query) {
		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_events'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		if ($this->noIDs) {
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}
		return array((int) $id => $id);
	}
	public function getEventId($segment, $query) {

		if ($this->noIDs) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__splms_events'))
				->where('alias = ' . $dbquery->q($segment));
			$db->setQuery($dbquery);
			return (int) $db->loadResult();
		}
		return (int) $segment;
	}

	// speaker
	public function getSpeakerSegment($id, $query) {
		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_speakers'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		if ($this->noIDs) {
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}
		return array((int) $id => $id);
	}
	public function getSpeakerId($segment, $query) {

		if ($this->noIDs) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__splms_speakers'))
				->where('alias = ' . $dbquery->q($segment));
			$db->setQuery($dbquery);
			return (int) $db->loadResult();
		}
		return (int) $segment;
	}

	// quizquestion
	public function getQuizquestionSegment($id, $query) {
		if (!strpos($id, ':')) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('alias'))
			->from($dbquery->qn('#__splms_quizquestions'))
			->where('id = ' . $dbquery->q($id));
			$db->setQuery($dbquery);

			$id .= ':' . $db->loadResult();
		}

		if ($this->noIDs) {
			list($void, $segment) = explode(':', $id, 2);

			return array($void => $segment);
		}
		return array((int) $id => $id);
	}
	public function getQuizquestionId($segment, $query) {

		if ($this->noIDs) {
			$db = JFactory::getDbo();
			$dbquery = $db->getQuery(true);
			$dbquery->select($dbquery->qn('id'))
				->from($dbquery->qn('#__splms_quizquestions'))
				->where('alias = ' . $dbquery->q($segment));
			$db->setQuery($dbquery);
			return (int) $db->loadResult();
		}
		return (int) $segment;
	}

}

/**
 * Users router functions
 *
 * These functions are proxys for the new router interface
 * for old SEF extensions.
 *
 * @param   array  &$query  REQUEST query
 *
 * @return  array  Segments of the SEF url
 *
 * @deprecated  4.0  Use Class based routers instead
 */
function splmsBuildRoute(&$query){
	$app = JFactory::getApplication();
	$router = new SplmsRouter($app, $app->getMenu());

	return $router->build($query);
}

/**
 * Convert SEF URL segments into query variables
 *
 * @param   array  $segments  Segments in the current URL
 *
 * @return  array  Query variables
 *
 * @deprecated  4.0  Use Class based routers instead
 */
function splmsParseRoute($segments){
	$app = JFactory::getApplication();
	$router = new SplmsRouter($app, $app->getMenu());

	return $router->parse($segments);
}
