<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsModelPayment extends JModelList {

	public function __construct($config = array()) {
    	parent::__construct($config);
	}

	// paypal inserted order
	public function storeOrder($order_info = array()){
		//$payment_status = ($order_info['payment_status'] == 'Completed') ? 1 : 0 ;

		$params = JComponentHelper::getParams('com_splms');
		if ($params->get('shop_environment') == 'sandbox') {
			$payment_status = 1;
		} else {
			$payment_status = ($order_info['payment_status'] == 'Completed') ? 1 : 0 ;
		}

		// $db = JFactory::getDbo();
		// $nullDate = $db->quote($db->getNullDate());
		// $nowDate  = $db->quote(JFactory::getDate()->toSql());

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$columns = array('order_user_id', 'course_id', 'order_price', 'order_payment_price', 'order_payment_id', 'order_payment_method', 'invoice_id', 'published', 'order_payment_currency');
		$values  = array($db->quote($order_info['user_id']), $db->quote($order_info['item_number']), $db->quote($order_info['payment_amount']), $db->quote($order_info['payment_amount']), $db->quote($order_info['txn_id']), $db->quote('paypal'), $db->quote($order_info['invoice_id']), $payment_status, $db->quote($order_info['payment_currency']) );

		$query
		    ->insert($db->quoteName('#__splms_orders'))
		    ->columns($db->quoteName($columns))
		    ->values(implode(',', $values));

	    $db->setQuery($query);
	    $db->execute();

		return true;
	}

	//paypal refund order
	public function refundOrder($order_info) {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		// Fields to update.
		$fields = array(
			$db->quoteName('published') . ' = 0'
		);
		// Conditions for which records should be updated.
		$conditions = array(
		    $db->quoteName('order_payment_id') . ' = ' . $db->quote($order_info['txn_id']),
		    $db->quoteName('invoice_id') . ' = '.$db->quote($order_info['invoice_id']),
		    $db->quoteName('course_id') . ' = ' .$db->quote($order_info['item_number'])
		);
		$query->update($db->quoteName('#__splms_orders'))->set($fields)->where($conditions);
	    $db->setQuery($query);
	    $db->execute();

	}

	//Check Duplicate Order
	public function getDublicateTransaction($transaction_id = '', $itemid = '', $user_id = '') {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'order_payment_id')));
		$query->from($db->quoteName('#__splms_orders'));
		$query->where($db->quoteName('published')." = 1");
		if($transaction_id){
		    $query->where($db->quoteName('order_payment_id')." = ".$db->quote($transaction_id));    
		}
		if($itemid){
		    $query->where($db->quoteName('course_id')." = ".$db->quote($itemid));
		}
		if($user_id){
		    $query->where($db->quoteName('order_user_id')." = ".$db->quote($user_id));
		}
		$query->order('ordering DESC');
		$db->setQuery($query);
		$result = $db->loadObject();

	 	if($result){
		    return true;   
		}
		
		return false;
	}

	// direct payment order
	public function insertOrders( $ordersinfo = array() ){

		foreach ( $ordersinfo as $orderinfo ) {

			$input = JFactory::getApplication()->input;
			$payment_method = $input->get('pm', 'direct', 'WORD');
			$payment_note = $input->get('payment_note', '', 'STRING');
			//$payment_note = (isset($input->get('payment_note', '', 'WORD')) && $input->get('payment_note', '', 'WORD')) ? $input->get('payment_note', '', 'WORD') : '' ;

			$db = JFactory::getDbo();
			$query = $db->getQuery(true);

			// generate invoice no
			$today = JFactory::getDate();
			$today = JHtml::_('date', $today, 'Ymd');
			$rand = strtoupper(substr(uniqid(sha1(time())),0,6));
			$uniqueno = $rand . $today;

			$orderinfo['order_payment_id'] = $uniqueno;
			$orderinfo['order_payment_method'] = $payment_method;
			$orderinfo['invoice_id'] = $uniqueno;
			$orderinfo['payment_note'] = $payment_note;

			$columns = array('order_user_id', 'course_id', 'order_price', 'order_payment_price', 'order_payment_id', 'order_payment_method', 'invoice_id', 'payment_note', 'published');
			$values  = array($db->quote($orderinfo['user_id']), $db->quote($orderinfo['product_id']), $db->quote($orderinfo['price']), $db->quote($orderinfo['price']), $db->quote($orderinfo['order_payment_id']), $db->quote($orderinfo['order_payment_method']), $db->quote($orderinfo['invoice_id']), $db->quote($orderinfo['payment_note']), 0);

			$query
			    ->insert($db->quoteName('#__splms_orders'))
			    ->columns($db->quoteName($columns))
			    ->values(implode(',', $values));

		    $db->setQuery($query);
		    $db->execute();
		}

		return true;
	}

}
