<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsModelEvents extends JModelList {

	protected function getListQuery() {
		$app = JFactory::getApplication();
		$user = JFactory::getUser();

		$app 			= JFactory::getApplication();
		$params   		= $app->getMenu()->getActive()->params; // get the active item
		$ordering 		= $params->get('ordering', ' DESC');
		$category_id 	= $params->get('category_id', '');

		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.*');
		$query->from($db->quoteName('#__splms_events', 'a'));

		//Authorised
		$groups = implode(',', $user->getAuthorisedViewLevels());
		$query->where('a.access IN (' . $groups . ')');

		if ($category_id) {
			$query->where($db->quoteName('a.eventcategory_id')." = " . $db->quote($category_id));
		}

		if ($ordering=='upcoming') {
			$query->where($db->quoteName('a.event_start_date') . ' > ' . $db->quote($now));
			$query->order($db->quoteName('a.event_start_date') . ' ASC');
		} elseif ($ordering=='latest') {
			$query->where($db->quoteName('a.event_start_date') . ' <= ' . $db->quote($now));
			$query->order($db->quoteName('a.event_start_date') . ' DESC');
		} elseif ($ordering== 'asc') {
			$query->order($db->quoteName('a.ordering') . ' ASC');
		} else {
			$query->order($db->quoteName('a.ordering') . ' DESC');
		}

		// Filter by language
		$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		$query->where('a.published = 1');

		return $query;
	}

	protected function populateState($ordering = null, $direction = null) {
		$app = JFactory::getApplication('site');
		$params = $app->getParams();
		$this->setState('list.start', $app->input->get('limitstart', 0, 'uint'));
		$limit = $params->get('limit');
		$this->setState('list.limit', $limit);
	}

	//if item not found
	public function &getItem($id = null) {
		$item = parent::getItem($id);
		if(JFactory::getApplication()->isSite()) {
			if($item->id) {
				return $item;
			} else {
				return JError::raiseError(404, JText::_('COM_SPLMS_NO_ITEMS_FOUND'));
			}
		} else {
			return $item;
		}
	}

	// Get All Events
	public static function getAllEvents() {
		// get current time
		$nowDate = JFactory::getDate()->format('Y-m-d');
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'title', 'alias', 'image', 'description', 'event_time', 'event_end_time','speaker_id')));
		$query->from($db->quoteName('#__splms_events'));
		$query->where($db->quoteName('published')." = 1");
		//Time sorting
		$query->where($db->qn('event_start_date')." > ".$db->quote($nowDate));
		//order
		$query->order($db->quoteName('event_start_date') . ' ASC');
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();

		foreach ($results as &$result) {
			$result->url = JRoute::_('index.php?option=com_splms&view=event&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('events'));
		}

		return $results;
	}


	// Get Event category by event
	public static function getEventCategory($id) {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'title', 'alias', 'image')));
		$query->from($db->quoteName('#__splms_eventcategories'));
		$query->where($db->quoteName('published')." = 1");
		$query->where($db->quoteName('eventcategory_id')." = ".$db->quote($id));
		$query->order('ordering DESC');
		$db->setQuery($query);
		$result = $db->loadObject();

		$result->url = JRoute::_('index.php?option=com_splms&view=eventcategory&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('events'));

		return $result;
	}

	// Get Event Speakers by event
	public static function getEventSpeakers($ids) {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		if (is_array($ids) == false) {
			$replaceArr  	 = array("\"","[","]");
			$speakerids 	 = str_replace( $replaceArr,"", $ids);
		}else{
			$speakerids = implode(',', $ids);
		}

		if (!empty($speakerids)) {
			$query->select($db->quoteName(array('id', 'title', 'alias', 'designation', 'image')));
			$query->from($db->quoteName('#__splms_speakers'));
			$query->where($db->quoteName('published')." = 1");
			$query->where($db->quoteName('id')." IN (". $speakerids . ")");
			$query->order('ordering DESC');
			$db->setQuery($query);
			$items = $db->loadObjectList();
			foreach ($items as &$item) {
				$item->url = JRoute::_('index.php?option=com_splms&view=speaker&id='.$item->id.':'.$item->alias . SplmsHelper::getItemid('speakers'));
			}
		}else{
			$items='';
		}

		return $items;
	}

	//Get Events By category
	public static function getEventByCategory($eventcategory_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'title', 'alias', 'description', 'image', 'event_start_date', 'event_end_date', 'event_time', 'event_address', 'price','speaker_id')));
		$query->from($db->quoteName('#__splms_events'));
		$query->where($db->quoteName('published')." = 1");
		$query->where($db->quoteName('eventcategory_id')." = ".$db->quote($eventcategory_id));
		$query->order('ordering DESC');
		$db->setQuery($query);
		$results = $db->loadObjectList();
		foreach ($results as &$result) {
			$result->url = JRoute::_('index.php?option=com_splms&view=event&id='.$result->id.':'.$result->alias . SplmsHelper::getItemid('events'));
		}

		return $results;
	}

}
