<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No Direct Access
defined ('_JEXEC') or die('Resticted Aceess');

class SplmsControllerTeachers extends JControllerLegacy {

	public function getModel($name = 'form', $prefix = '', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config); 
		return $model; 
	}

	public function display($cachable = false, $urlparams = false, $tpl = null){

		$cachable = true;
		if (!is_array($urlparams)) {
			$urlparams = [];
		}
		$additionalParams = array(
			'catid' => 'INT',
			'id' => 'INT',
			'cid' => 'ARRAY',
			'year' => 'INT',
			'month' => 'INT',
			'limit' => 'UINT',
			'limitstart' => 'UINT',
			'showall' => 'INT',
			'return' => 'BASE64',
			'filter' => 'STRING',
			'filter_order' => 'CMD',
			'filter_order_Dir' => 'CMD',
			'filter-search' => 'STRING',
			'print' => 'BOOLEAN',
			'lang' => 'CMD',
			'Itemid' => 'INT');

		$urlparams = array_merge($additionalParams, $urlparams);
		parent::display($cachable, $urlparams, $tpl);
	}

	public function contact(){

		//$model 		= $this->getModel();

		$input 		= JFactory::getApplication()->input;
		$mail  		= JFactory::getMailer();

		$name 		= $input->post->get('name', NULL, 'STRING');
		$email 		= $input->post->get('email', NULL, 'STRING');
		$phone 		= $input->post->get('phone', NULL, 'STRING');
		$message 	= $input->post->get('message', NULL, 'STRING');
		$subject 	= $input->post->get('subject', NULL, 'STRING');
		$recipient = base64_decode($input->post->get('teacher_email', NULL, 'STRING'));

		//message body
		$visitorip      = isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR'];
		
		// get site name 
		$site_name 		= isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : '';
		$subject 		= $subject . ' | Email Address: ' . $email . ' | ' . $site_name;

		$msg  = '';
		$msg .= '<p><span>Name : ' . $name .'</span></p>';
		$msg .= '<p><span>Phone : ' . $phone .'</span></p>';
		$msg .= '<p><span>Sender IP : ' . $visitorip .'</span></p>';
		$msg .= '<p><span>Email : ' . $email .'</span></p> <br />';
		$msg .= '<p><span>Message :</span> <br />' . $message .'</p>';

		// Sent email
		$sender = array($email, $name);
		$mail->setSender($sender);
		$mail->addRecipient($recipient);
		$mail->setSubject($subject);
		$mail->isHTML(true);
		$mail->Encoding = 'base64';
		$mail->setBody($msg);

		$output = array();
		$output['status'] = false;
		if ($mail->Send()) {
			$output['status'] = true;
			$output['content'] = JText::_('COM_SPLMS_TEACHER_CONTACT_SUCCESS');
		} else {
			$output['content'] = JText::_('COM_SPLMS_TEACHER_CONTACT_ERROR');
		}

		echo json_encode($output);
		die();
	}

	
}
