<?php
/**
* @package RSMediaGallery!
* @copyright (C) 2011-2014 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/

defined('_JEXEC') or die('Restricted access');
?>
<?php if (!empty($this->classFx)) { ?>
	<div class="<?php echo $this->classFx; ?>">
<?php } ?>
	<?php if ($this->params->get('show_page_heading', 1)) { ?>
		<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
	<?php } ?>
	
	<div id="rsmg_main" class="rsmg_fullwidth">
		<?php if ($this->prev) { ?>
		<a href="<?php echo RSMediaGalleryRoute::_('index.php?option=com_rsmediagallery&view=rsmediagallery'.($this->limitstart - $this->limit > 0 ? '&limitstart='.($this->limitstart - $this->limit) : '')); ?>" id="rsmg_prev_page" class="rsmg_big_button"><?php echo JText::_('COM_RSMEDIAGALLERY_PREV_PAGE'); ?></a>
		<?php } ?>
		
		<?php if ($this->items) { ?>
		<?php if ($this->animation) { ?>
			<ul id="rsmg_gallery_filters">
				<li class="filter active" data-filter="all"><?php echo JText::_('COM_RSMEDIAGALLERY_ALL');?></li>
				<?php foreach ( $this->tags as $tag ) { ?>
					<li class="filter" data-filter="<?php echo RSMediaGalleryHelper::niceTag($tag);?>" style="display:none;"><?php echo $this->escape($tag);?></li>
				<?php } ?>
			</ul>
		<?php } ?>
		<ul id="rsmg_gallery">
			<?php foreach ($this->items as $i => $item) { ?>
			<li <?php echo ($this->animation ? 'class="mix '.$item->niceTags.'"' : '' );?>>
				<div class="rsmg_item_container">
					<?php if ($this->social_sharing && $this->social_on_thumbs) { ?>
						<div class="rsmg_social_sharing">
							<?php if ($this->share_pinterest) { ?>
								<a class="rsmg-share social-icon-pinterest <?php echo $this->tootltipClass;?>" title="<?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON_PINTEREST')?><?php echo ($this->tootltipClass=='hasTip' ? '::' : ''); ?>" href="https://www.pinterest.com/pin/create/button/?url=<?php echo urlencode($item->social_href); ?>&media=<?php echo urlencode($item->full);?>&description=<?php echo urlencode($this->escape($item->description)) ?>" data-pin-do="buttonPin"></a>
							<?php } ?>
							<?php if ($this->share_twitter) { ?>
								<a class="rsmg-share social-icon-twitter <?php echo $this->tootltipClass;?>" title="<?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON_TWITTER')?><?php echo ($this->tootltipClass=='hasTip' ? '::' : ''); ?>" target="_blank" href="http://twitter.com/share?text=<?php echo $this->escape($item->title) ?>&url=<?php echo $this->buildTwitterLink($item->social_href); ?>"></a>
							<?php } ?>
							<?php if ($this->share_facebook) { ?>
								<a class="rsmg-share social-icon-facebook <?php echo $this->tootltipClass;?>" title="<?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON_FACEBOOK')?><?php echo ($this->tootltipClass=='hasTip' ? '::' : ''); ?>" target="_blank" href="http://www.facebook.com/sharer.php?s=100&amp;p[title]=<?php echo urlencode($this->escape($item->title));?>&amp;p[summary]=<?php echo urlencode($this->escape($item->description)) ?>&amp;p[url]=<?php echo urlencode($item->social_href); ?>&amp;p[images][0]=<?php echo urlencode($item->thumb); ?>"></a>
							<?php } ?>
						</div>
					<?php } ?>
					<a class="rsmg_lightbox" <?php if ($this->params->get('open_in_new_page', 0)) { ?>target="_blank"<?php } ?> href="<?php echo $item->href; ?>" rel="{'link': '<?php echo addslashes($item->full); ?>', 'title': '#rsmg_item_<?php echo $i; ?>', 'id': '<?php echo $item->id; ?>', 'group' : 'all'}" title=""><img src="<?php echo $item->thumb; ?>" width="<?php echo $item->thumb_width; ?>" height="<?php echo $item->thumb_height; ?>" style="width:<?php echo $item->thumb_width; ?>px; height:<?php echo $item->thumb_height; ?>px;" alt="<?php echo $this->escape($item->title); ?>" /></a>
					<?php if ($this->params->get('show_title_list', 1)) { ?>
					<a <?php if ($this->params->get('open_in_new_page', 0)) { ?>target="_blank"<?php } ?> href="<?php echo $item->href; ?>" class="rsmg_title rsmg_lightbox" rel="{'link': '<?php echo addslashes($item->full); ?>', 'title': '#rsmg_item_<?php echo $i; ?>', 'id': '<?php echo $item->id; ?>', 'group' : 'all'}"><?php echo $this->escape($item->title); ?></a>
					<?php } ?>
					<?php if ($this->params->get('show_description_list', 1)) { ?>
					<span class="rsmg_item_description"><?php echo $item->description; ?></span>
					<?php } ?>
					<div id="rsmg_item_<?php echo $i; ?>" style="display: none; position:relative">
						<?php if ($this->social_sharing && $this->social_on_details) { ?>
							<div class="rsmg_social_sharing_detail<?php echo ($this->params->get('show_title_detail', 1) ? '' : ' rsmg_social_no_title');?>">
								<?php if ($this->share_pinterest) { ?>
									<a class="rsmg-share social-icon-pinterest" title="<?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON_PINTEREST')?>" href="https://www.pinterest.com/pin/create/button/?url=<?php echo urlencode($item->social_href); ?>&media=<?php echo urlencode($item->full);?>&description=<?php echo urlencode($this->escape($item->description)) ?>" data-pin-do="buttonPin"></a>
								<?php } ?>
								<?php if ($this->share_twitter) { ?>
									<a class="rsmg-share social-icon-twitter" title="<?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON_TWITTER')?>" target="_blank" href="http://twitter.com/share?text=<?php echo $this->escape($item->title) ?>&url=<?php echo $this->buildTwitterLink($item->social_href); ?>"></a>
								<?php } ?>
								<?php if ($this->share_facebook) { ?>
									<a class="rsmg-share social-icon-facebook" title="<?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON_FACEBOOK')?>" target="_blank" href="http://www.facebook.com/sharer.php?u=<?php echo urlencode($item->social_href); ?>"></a>
								<?php } ?>
								<span class="rsmg_details_caption"><?php echo JText::_('COM_RSMEDIAGALLERY_SHARE_ON')?></span>
							</div>
						<?php } ?>
						<?php if ($this->params->get('show_title_detail', 1)) { ?>
						<h2 class="rsmg_title"><?php echo $this->escape($item->title); ?></h2>
						<?php } ?>
						<?php if ($this->params->get('show_description_detail', 1)) { ?>
							<p class="rsmg_image_description"><?php echo $item->full_description; ?></p>
						<?php } ?>
						<span class="rsmg_clear"></span>
						<?php if ($this->params->get('download_original', 1)) { ?>
						<div class="rsmg_download rsmg_toolbox"><a href="<?php echo RSMediaGalleryRoute::_('index.php?option=com_rsmediagallery&task=downloaditem&id='.$item->filepart.'&ext='.$item->fileext); ?>"><?php echo JText::_('COM_RSMEDIAGALLERY_DOWNLOAD'); ?></a></div>
						<?php } ?>
						<?php if ($this->params->get('show_hits', 1)) { ?>
						<div class="rsmg_views rsmg_toolbox"><?php echo JText::sprintf($item->hits == 1 ? 'COM_RSMEDIAGALLERY_HIT' : 'COM_RSMEDIAGALLERY_HITS', $item->hits); ?></div>
						<?php } ?>
						<?php if ($this->params->get('show_created', 1)) { ?>
						<div class="rsmg_calendar rsmg_toolbox"><?php echo JText::sprintf('COM_RSMEDIAGALLERY_CREATED', $this->escape($item->created)); ?></div>
						<?php } ?>
						<?php if ($this->params->get('show_modified', 1)) { ?>
						<div class="rsmg_calendar rsmg_toolbox"><?php echo JText::sprintf('COM_RSMEDIAGALLERY_MODIFIED', $this->escape($item->modified)); ?></div>
						<?php } ?>
						<span class="rsmg_clear"></span>
						<?php if ($this->params->get('show_tags', 1)) { ?>
						<p class="rsmg_tags"><?php echo JText::_('COM_RSMEDIAGALLERY_TAGS'); ?>: <strong><?php echo $this->escape($item->tags); ?></strong></p>
						<?php } ?>
					</div>
				</div>
			</li>
			<?php } ?>
		</ul><!-- rsmg_gallery -->
		<?php } ?>
		
		<?php if ($this->more) { ?>
		<a href="<?php echo RSMediaGalleryRoute::_('index.php?option=com_rsmediagallery&view=rsmediagallery&limitstart='.($this->limitstart + $this->limit)); ?>" rel="<?php echo $this->total - $this->limitstart; ?>" id="rsmg_load_more" class="rsmg_big_button"><?php echo JText::_('COM_RSMEDIAGALLERY_NEXT_PAGE'); ?></a>
		<?php } ?>
		
		<input type="hidden" name="Itemid" id="rsmg_itemid" value="<?php echo $this->itemid; ?>" />
		<input type="hidden" id="rsmg_original_limitstart" value="<?php echo $this->limitstart; ?>" />
	</div><!-- rsmg_main -->
	<span class="rsmg_clear"></span>
	<?php if ($this->params->get('show_credits', 1)) { ?>
	<div id="rsmg_footer">
		<?php echo JText::sprintf('COM_RSMEDIAGALLERY_FOOTER_CREDITS', 'https://www.rsjoomla.com/joomla-extensions/joomla-gallery.html'); ?>
	</div>
	<?php } ?>
<?php if (!empty($this->classFx)) { ?>
	</div>
<?php } ?>