<?php
/**
* @package RSMediaGallery!
* @copyright (C) 2011-2014 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/

defined('_JEXEC') or die('Restricted access');

jimport( 'joomla.application.component.view');

class RSMediaGalleryViewAlbum extends JViewLegacy
{
	public function display($tpl = null)
	{
		// verify that the menu item exists
		if (is_null(JFactory::getApplication()->getMenu()->getActive())) {
			JFactory::getApplication()->redirect(JUri::root());
		}
		
		jimport('joomla.application.component.helper');
		
		require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/helper.php';
		require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/jquery.php';
		
		$mainframe 			= JFactory::getApplication();
		$document  			= JFactory::getDocument();
		$componentParams	= JComponentHelper::getParams('com_rsmediagallery');
		$jqueryHelper		= RSMediaGalleryjQuery::getInstance();
		$params    			= $this->get('AlbumParams');
		
		// the page class suffix
		$this->classFx = trim($this->escape($params->get('pageclass_sfx','')));
		
		$jversion  			= new JVersion();
		
		// set the tooltip for each joomla version
		if ($jversion->isCompatible('3.0')) {
			if ($jversion->isCompatible('3.3')) {
				JHtml::_('behavior.core');
			}
			
			JHtml::_('bootstrap.tooltip');
			$this->tootltipClass = 'hasTooltip';
		} else {
			JHtml::_('behavior.tooltip');
			$this->tootltipClass = 'hasTip';
		}
		
		$document->addScriptDeclaration("var rsmg_tooltip_class='".$this->tootltipClass."'");
		
		$this->responsive   = $params->get('responsive');
		$this->itemsrow     = $params->get('itemsrow');
		
		$this->loadingbar	= $params->get('loadingbar_type', 'none');
		
		// update 1.7.5
		$this->itemsrow	= ($this->itemsrow > 6 ? 6 : ($this->itemsrow == 5 ? 4 : $this->itemsrow));
		
		
		$jqueryHelper->addjQuery();
		
		// social sharing
		$this->share_facebook 	 = (int) $params->get('share_facebook', 0);
		$this->share_twitter 	 = (int) $params->get('share_twitter', 0);
		$this->share_pinterest 	 = (int) $params->get('share_pinterest', 0);
		
		$this->social_on_thumbs  = (int) $params->get('social_on_thumbs', 1);
		$this->social_on_details = (int) $params->get('social_on_details', 1);
		$this->social_sharing 	 =  $this->share_facebook || $this->share_twitter || $this->share_pinterest;
		
		// javascript variables needed for load mor button
		$sharingJsVariables = "var rsmg_social_sharing_on_thumbs 	= ".(($this->social_sharing && $this->social_on_thumbs) ? 'true' : 'false').";\n";
		$sharingJsVariables .= "var rsmg_social_sharing_on_details  = ".(($this->social_sharing && $this->social_on_details) ? 'true' : 'false').";\n";
		$sharingJsVariables .= "var rsmg_sharing_facebook 			= ".($this->share_facebook ? 'true' : 'false').";\n";
		$sharingJsVariables .= "var rsmg_sharing_twitter 			= ".($this->share_twitter ? 'true' : 'false').";\n";
		$sharingJsVariables .= "var rsmg_sharing_pinterest 			= ".($this->share_pinterest ? 'true' : 'false').";\n";
		
		$document->addScriptDeclaration($sharingJsVariables);
		
		if ($this->share_facebook || $this->share_twitter || $this->share_pinterest) {
			$document->addScriptDeclaration("jQuery(document).ready(function($){
				$('.rsmg-share').on('click', function(){
					var top 	= ($(window).height() / 2) - 150;
					var left 	= ($(window).width() / 2) - 200;
					window.open(this.href, '','top='+top+', left='+left+', width=400, height=300');
					return false;
				});
			});");
		}

		$src = JDEBUG ? '.src' : '';
		
		$document->addScriptDeclaration("jQuery.noConflict();");
		$document->addScriptDeclaration("function rsmg_get_root() { return '".addslashes(rtrim(JURI::root(), '/'))."'; }");
		$document->addScriptDeclaration("rsmg_add_lang({'COM_RSMEDIAGALLERY_LOAD_MORE': '".JText::_('COM_RSMEDIAGALLERY_LOAD_MORE', true)."', 'COM_RSMEDIAGALLERY_LOAD_ALL': '".JText::_('COM_RSMEDIAGALLERY_LOAD_ALL', true)."', 'COM_RSMEDIAGALLERY_DOWNLOAD': '".JText::_('COM_RSMEDIAGALLERY_DOWNLOAD', true)."', 'COM_RSMEDIAGALLERY_TAGS': '".JText::_('COM_RSMEDIAGALLERY_TAGS', true)."', 'COM_RSMEDIAGALLERY_HIT': '".JText::_('COM_RSMEDIAGALLERY_HIT', true)."', 'COM_RSMEDIAGALLERY_HITS': '".JText::_('COM_RSMEDIAGALLERY_HITS', true)."', 'COM_RSMEDIAGALLERY_CREATED': '".JText::_('COM_RSMEDIAGALLERY_CREATED', true)."', 'COM_RSMEDIAGALLERY_MODIFIED': '".JText::_('COM_RSMEDIAGALLERY_MODIFIED', true)."'});");
		
		
		$layout = $this->getLayout();
		
		
		$center_list = $params->get('center_list');
		$script = '';
		if ($center_list && $layout != 'image') {
			$script .= 'var center_list = true;';
		}
		else { 
			$script .= 'var center_list = false;';
		}
		
		if($this->responsive){
			$script .= 'var responsive = true;
			var itemsrow = '.$this->itemsrow.';';
		}
		else {
			$script .= 'var responsive = false;';
		}
		
		$document->addScriptDeclaration($script);

		$document->addScript(JURI::root(true).'/components/com_rsmediagallery/assets/js/jquery.script'.$src.'.js');
		if ($this->loadingbar != 'none') {
			$document->addScript(JURI::root(true).'/components/com_rsmediagallery/assets/js/jquery.loadingbar'.$src.'.js');
		}
		
		$document->addStyleSheet(JURI::root(true).'/components/com_rsmediagallery/assets/css/style.css');
		$document->addStyleSheet(JURI::root(true).'/components/com_rsmediagallery/assets/css/'.($componentParams->get('contrast', 'light')).'.css');
		if ($this->loadingbar != 'none') {
			$document->addStyleSheet(JURI::root(true).'/components/com_rsmediagallery/assets/css/loadingbar.css');
		}
		
		if($this->responsive && $componentParams->get('resposive_css',1)) {
			$document->addStyleSheet(JURI::root(true).'/components/com_rsmediagallery/assets/css/rsmg_responsive.css');
		}
		
		$document->addStyleSheet(JURI::root(true).'/components/com_rsmediagallery/assets/css/style_'.($this->responsive ? 'responsive' : 'normal').'.css');
		
		$this->tag = $this->get('Tags');
		
		
		if ($layout == 'image')
		{
			$this->item = $this->get('item');
			$this->currentUrl = JURI::getInstance()->toString();
			// not an item ?
			if (!$this->item)
			{
				JFactory::getApplication()->enqueueMessage(JText::_('COM_RSMEDIAGALLERY_NOT_FOUND'), 'error');
				return;
			}
			
			if ($params->get('use_original', 0))
				$this->item->src = JURI::root().'/components/com_rsmediagallery/assets/gallery/original/'.$this->item->filename;
			else {
				$full_width  = $params->get('full_width', 800);
				$full_height = $params->get('full_height', 600);
				$this->item->src = RSMediaGalleryHelper::getImage($this->item, $full_width, $full_height, true);
			}
			
			if ($this->social_sharing) {
				if ($this->share_facebook) {
					$document->addCustomTag('<meta property="og:title" content="'.$this->escape($this->item->title).'"/>');
					$document->addCustomTag('<meta property="og:url" content="'.$this->escape(JURI::current()).'"/>');
					$document->addCustomTag('<meta property="og:image" content="'.$this->escape($this->item->src).'"/>');
					$document->addCustomTag('<meta property="og:description" content="'.$this->escape($this->item->description).'"/>');
				}
			}
			
			// set page title
			$document->setTitle($document->getTitle().' - '.$this->item->title);
			
			// set breadcrumbs
			$pathway = $mainframe->getPathway();
			$pathway->addItem($this->tag, RSMediaGalleryRoute::_('index.php?option=com_rsmediagallery&view=album&tag='.urlencode($this->tag)));
			
			$pathway = $mainframe->getPathway();
			$pathway->addItem($this->item->title, '');
			
			// assign variables to the layout
			$this->adjacent = $this->get('adjacentitems');
			$this->params = $params;
			
			// don't forget to increase the views
			$model = $this->getModel('album');
			$model->hitItem($this->item->id);
		}
		else
		{
			$document->addScript(JURI::root(true).'/components/com_rsmediagallery/assets/js/jquery.lightbox2'.$src.'.js');
			$document->addStyleSheet(JURI::root(true).'/components/com_rsmediagallery/assets/css/lightbox.css');
			
			$open_in = $params->get('open_in', 'slideshow');
			if ($open_in == 'slideshow')
			{
				$document->addScriptDeclaration("
				/* <![CDATA[ */
				function rsmg_init_lightbox2() {
					jQuery('#rsmg_gallery a.rsmg_lightbox').lightBox({
						imageCloseText: '".JText::_('COM_RSMEDIAGALLERY_CLOSE_LIGHTBOX', true)."',
						ajaxFunction: function(settings) {
							more 			= false;
							original_length = jQuery('ul#rsmg_gallery li .rsmg_item_container').length;
							
							if (jQuery('#rsmg_load_more').length > 0 && !jQuery('#rsmg_load_more').is(':hidden'))
							{
								rsmg_get_items(jQuery, false, {}, function(data) {
								
									new_length = jQuery('ul#rsmg_gallery li .rsmg_item_container').length;
									if (new_length - original_length == 0)
										more = false;
									else
									{
										var images = jQuery('#rsmg_gallery a.rsmg_lightbox:not(.rsmg_title)');
										for (j = original_length; j<new_length; j++)
										{
											var currentImage = jQuery(images[j]);
											var rel = jQuery(currentImage).attr('rel');
											var href = currentImage.attr('src');
											var title = '';
											var id = 0;
											if (typeof rel != 'undefined' && rel.indexOf('{') > -1 && rel.indexOf('}') > -1)
											{
												eval('var decoded_rel = ' + rel + ';');
												if (typeof decoded_rel == 'object')
												{
													if (typeof decoded_rel.link != 'undefined')
														href = decoded_rel.link;
													
													if (typeof decoded_rel.id != 'undefined')
														id = decoded_rel.id;
												}
											}
											settings.addImage(settings, href, '#rsmg_item_' + j, id, 'all');
										}
										
										more = true;
									}
								}, false);
							}
							return more;
						},
						onImageLoad: rsmg_hit_item,
						afterImageLoad: function(){
							".($this->social_sharing ? "jQuery('.rsmg-share').unbind('click').bind('click', function(){
								var top 	= (jQuery(window).height() / 2) - 150;
								var left 	= (jQuery(window).width() / 2) - 200;
								window.open(this.href, '','top='+top+', left='+left+', width=400, height=300');
								return false;
							});": "")."
							return false;
						}
					});
				}
				/* ]]> */
				");
			}
			
			$thumb_width = $params->get('thumb_width', 280);
			if ($thumb_width > 0 && !$this->responsive)
				$document->addStyleDeclaration('ul#rsmg_gallery li div { width: '.(int) $thumb_width.'px; }');
			
			$items = $this->get('items');
			if ($items)
			{
				foreach ($items as $i => $item)
					$items[$i] = RSMediaGalleryHelper::parseItem($item, $params, true);
				RSMediaGalleryHelper::addTags($items);
			}
			
			// set breadcrumbs
			$pathway = $mainframe->getPathway();
			$pathway->addItem($this->tag, '');
			
			// assign variables to the layout
			$this->params 		= $params;
			$this->items 		= $items;
			$this->total 		= $this->get('total');
			$this->limitstart 	= $this->get('limitstart');
			$this->limit 		= $this->get('limit');
			$this->more 		= ($this->limit > 0 ? ($this->limitstart + $this->limit < $this->total) : false);
			$this->prev			= $this->limitstart > 0;
			$this->itemid		= $this->get('itemid');
			
			$this->_prepareDocument();
		}
		
		parent::display($tpl);
	}
	
	protected function buildTwitterLink($link) {
		$link = urlencode($link);
		$link = str_replace('amp%3B', '', $link);
		
		return $link;
	}
	
	protected function _prepareDocument() {
		$title = $this->tag;
		$this->document->setTitle($title);
	}
}