<?php
/**
* @package RSMediaGallery!
* @copyright (C) 2011-2014 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/

defined('_JEXEC') or die('Restricted access');

class RSMediaGalleryController extends JControllerLegacy
{
	public function createThumb()
	{
		$mainframe	= JFactory::getApplication();
		$db 	 	= JFactory::getDbo();
		$res	 	= $mainframe->input->getCmd('resolution');
		$hash	 	= md5($res.JPATH_SITE);
		$model	  	= $this->getModel('rsmediagallery');
		$id			= $model->_getId();

		$query = $db->getQuery(true)
			->select('*')
			->from($db->qn('#__rsmediagallery_items'))
			->where($db->qn('filename').'='.$db->q($id));
		if ($item = $db->setQuery($query)->loadObject()) {
			$id 			  		= $item->filename;
			$item->params	  		= unserialize($item->params);
			$admin_thumb 			= $res == '280x210';
			list($width, $height) 	= explode('x', $res);
			$upload_location  		= JPATH_SITE.'/components/com_rsmediagallery/assets/gallery';
			$thumb_location	  		= $admin_thumb ? $upload_location : $upload_location.'/'.$res;
			$isFilter		 		 = !empty($item->params['filters']);

			jimport('joomla.filesystem.file');
			jimport('joomla.filesystem.folder');

			$isNewFilter = false;
			// Verify previous filter hash
			if ($isFilter) {
				$hashFilter = md5($res.$item->params['filters']);
				$query->clear()
					->select('*')
					->from($db->qn('#__rsmediagallery_effects'))
					->where($db->qn('item_id').'='.$db->q($item->id))
					->where($db->qn('hash').'='.$db->q($hashFilter));
				$isNewFilter = !$db->setQuery($query)
					->loadObject();
			}

			if (!file_exists($thumb_location.'/'.$id) || ($isFilter && (($isNewFilter && file_exists($thumb_location.'/filter/'.$id)) || !file_exists($thumb_location.'/filter/'.$id)))) {
				// Check if hash exists in the database to prevent attacks on the server
				$query->clear()
					->select('*')
					->from($db->qn('#__rsmediagallery_thumbs'))
					->where($db->qn('hash').'='.$db->q($hash));
				if (!$db->setQuery($query)->loadObject()) {
					$mainframe->close();
				}

				require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/phpthumb/phpthumb.class.php';

				$phpThumb = new phpThumb();
				$phpThumb->src = $upload_location.'/original/'.$id;
				$phpThumb->w   = $width;
				$phpThumb->h   = $height;
				$phpThumb->iar = 1;
				$phpThumb->zc  = JFactory::getApplication()->input->getInt('zc');

				$fileExtension  = JFile::getExt($id);

				if ($fileExtension=='png' || $fileExtension=='gif') {
					$phpThumb->fltr = 'stc|FFFFFF|5|10';
					$phpThumb->f   = $fileExtension;
				}

				$ratio = $item->params['info'][0] / 380;

				$phpThumb->sx = round($item->params['selection']['x1']*$ratio);
				$phpThumb->sy = round($item->params['selection']['y1']*$ratio);
				$phpThumb->sw = round(($item->params['selection']['x2'] - $item->params['selection']['x1'])*$ratio);
				$phpThumb->sh = round(($item->params['selection']['y2'] - $item->params['selection']['y1'])*$ratio);

				// bug fix
				if ($phpThumb->sx == 1 && $phpThumb->sw == $item->params['info'][0] - 1)
				{
					$phpThumb->sx = 0;
					$phpThumb->sw = $item->params['info'][0];
				}
				if ($phpThumb->sy == 1 && $phpThumb->sh == $item->params['info'][1] - 1)
				{
					$phpThumb->sy = 0;
					$phpThumb->sh = $item->params['info'][1];
				}

				if ($phpThumb->GenerateThumbnail())
				{
					if (!$admin_thumb && !is_dir($thumb_location))
					{
						// set folder permissions
						$componentParams = JComponentHelper::getParams('com_rsmediagallery');
						$perms 			 = octdec('0'.$componentParams->get('folder_perms', '755'));

						if (JFolder::create($thumb_location, $perms))
						{
							$buffer = '<html><body bgcolor="#FFFFFF"></body></html>';
							JFile::write($thumb_location.'/index.html', $buffer);
						}
					}
					if ($phpThumb->RenderToFile($thumb_location.'/'.$id))
					{
						// set permissions as setup in the configuration screen
						$componentParams = JComponentHelper::getParams('com_rsmediagallery');
						$perms 			 = octdec('0'.$componentParams->get('file_perms', '644'));
						@chmod($thumb_location.'/'.$id, $perms);

						if($isFilter) {
							require_once JPATH_ADMINISTRATOR.'/components/com_rsmediagallery/helpers/helper.php';
							// copy the image with the proper effects
							RSMediaGalleryHelper::applyFilters($item->params['filters'], $id, $thumb_location.'/', true);

							// output
							echo RSMediaGalleryHelper::applyFilters($item->params['filters'], $id, $thumb_location.'/', false, true, $res);

							// Remove the old filters
							$query->clear()
								->delete($db->qn('#__rsmediagallery_effects'))
								->where($db->qn('hash').'!='.$db->q($hashFilter))
								->where($db->qn('item_id').'='.$db->q($item->id));
							$db->setQuery($query)
								->execute();
						}
						else {
							$phpThumb->OutputThumbnail();
						}
					} else {
						$phpThumb->errorImage(end($phpThumb->debugmessages), 0, 0, true);
					}
				} else {
					$phpThumb->errorImage(end($phpThumb->debugmessages), 0, 0, true);
				}
			} else {
				// Object exists, make sure it's not cached already
				require_once JPATH_ADMINISTRATOR . '/components/com_rsmediagallery/helpers/phpthumb/phpthumb.functions.php';

				header('Content-Type: ' . phpthumb_functions::ImageTypeToMIMEtype(JFile::getExt($id)));
				header('Content-Disposition: inline; filename="' . $id . '"');

				if ($isFilter) {
					echo file_get_contents($thumb_location . '/filter/' . $id);
				} else {
					echo file_get_contents($thumb_location . '/' . $id);
				}
			}
			
			// Remove hash from database
			$db->setQuery('DELETE FROM '.$db->qn('#__rsmediagallery_thumbs').' WHERE '.$db->qn('hash').'='.$db->q($hash).' LIMIT 1')
				->execute();
		}

		$mainframe->close();
		
		jexit();
	}
	
	public function getItems()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'items');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	public function getItemsAlbum()
	{
		JFactory::getApplication()->input->set('view',   'album');
		JFactory::getApplication()->input->set('layout', 'items');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function downloadItem()
	{
		$model = $this->getModel('rsmediagallery');
		$model->downloadItem();
	}
	
	public function hitItem()
	{
		$cid   =  JRequest::getVar('cid');
		$model = $this->getModel('rsmediagallery');
		$model->hitItem($cid);
		
		jexit();
	}
}