<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No direct access
defined('_JEXEC') or die('Restricted access');

class SplmsViewCoursescategory extends JViewLegacy {

	protected $form;
	protected $item;
	protected $canDo;
	protected $id;

	public function display($tpl = null) {
		// Get the Data
		$model = $this->getModel('Coursescategory');
		$this->form = $this->get('Form');
		$this->item = $this->get('Item');
		$this->id = $this->item->id;

		$this->canDo = SplmsHelper::getActions($this->item->id);

		// Check for errors.
		if (count($errors = $this->get('Errors'))){
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}

		$this->addToolBar();
		parent::display($tpl);
	}

	protected function addToolBar() {
		$input = JFactory::getApplication()->input;

		// Hide Joomla Administrator Main menu
		$input->set('hidemainmenu', true);

		$isNew = ($this->item->id == 0);

		JToolBarHelper::title(JText::_('COM_SPLMS_COURSE_CATEGORIES') . ': '.  ($isNew ? JText::_('COM_SPSPLMS_NEW') : JText::_('COM_SPSPLMS_EDIT')), 'pencil');

		if ($isNew) {
			// For new records, check the create permission.
			if ($this->canDo->get('core.create')) {
				JToolBarHelper::apply('coursescategory.apply', 'JTOOLBAR_APPLY');
				JToolBarHelper::save('coursescategory.save', 'JTOOLBAR_SAVE');
			}
			JToolBarHelper::cancel('coursescategory.cancel', 'JTOOLBAR_CANCEL');
		} else {
			if ($this->canDo->get('core.edit')) {
				// We can save the new record
				JToolBarHelper::apply('coursescategory.apply', 'JTOOLBAR_APPLY');
				JToolBarHelper::save('coursescategory.save', 'JTOOLBAR_SAVE');
			}
			JToolBarHelper::cancel('coursescategory.cancel', 'JTOOLBAR_CLOSE');
		}
	}
}
