<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No direct access
defined('_JEXEC') or die('Restricted access');

class SplmsTableCourse extends JTable {

	public function __construct(&$db) {
		parent::__construct('#__splms_courses', 'id', $db);
	}

	public function store($updateNulls = false) {
		$date = JFactory::getDate();
		$user = JFactory::getUser();

		if ($this->id) {
			$this->modified		= $date->toSql();
			$this->modified_by		= $user->get('id');
		} else {
			if (!(int) $this->created) {
				$this->created = $date->toSql();
			}
			if (empty($this->created_by)) {
				$this->created_by = $user->get('id');
			}
		}

		// Verify that the alias is unique
		$table = JTable::getInstance('Course', 'SplmsTable');

		if ($table->load(array('alias' => $this->alias)) && ($table->id != $this->id || $this->id == 0)) {
			$this->setError(JText::_('COM_SPLMS_ERROR_UNIQUE_ALIAS'));

			return false;
		}

		return parent::store($updateNulls);
	}

	public function check() {
		// Check for valid name.
		if (trim($this->title) == '') {
			throw new UnexpectedValueException(sprintf('The title is empty'));
		}

		if (empty($this->alias)) {
			$this->alias = $this->title;
		}

		$this->alias = JApplicationHelper::stringURLSafe($this->alias, $this->language);

		if (trim(str_replace('-', '', $this->alias)) == '') {
			$this->alias = JFactory::getDate()->format('Y-m-d-H-i-s');
		}

		//course_schedules
		if (is_array($this->course_schedules)){
			if (!empty($this->course_schedules)){
				$this->course_schedules = json_encode($this->course_schedules);
			}
		}
		if (is_null($this->course_schedules) || empty($this->course_schedules)){
			$this->course_schedules = '';
		}

		//course info
		if (is_array($this->course_infos)){
			if (!empty($this->course_infos)){
				$this->course_infos = json_encode($this->course_infos);
			}
		}
		if (is_null($this->course_infos) || empty($this->course_infos)){
			$this->course_infos = '';
		}

		//Generate Thumbnails
		if($this->image) {
			jimport('joomla.application.component.helper');
			$params = JComponentHelper::getParams('com_splms');

			$thumb = $params->get('course_thumbnail', '480X300');
			$thumb_small = $params->get('course_thumbnail_small', '100X60');

			if(isset($this->image) && $this->image) {
				jimport( 'joomla.filesystem.file' );
				jimport( 'joomla.filesystem.folder' );
				jimport( 'joomla.image.image' );
				$image = JPATH_ROOT . '/' . $this->image;
				$sizes = array($thumb, $thumb_small);
				$image = new JImage($image);
				$image->createThumbs($sizes, 5);
			}
		}

		return true;
	}

	public function onAfterLoad(&$result) {
		// course schedules
		if(!is_array($this->course_schedules)) {
			if(!empty($this->course_schedules)) {
				$this->course_schedules = json_decode($this->course_schedules, true);
			}
		}
		if(is_null($this->course_schedules) || empty($this->course_schedules)) {
			$this->course_schedules = array();
		}

		// course identification
		if(!is_array($this->course_infos)) {
			if(!empty($this->course_infos)) {
				$this->course_infos = json_decode($this->course_infos, true);
			}
		}
		if(is_null($this->course_infos) || empty($this->course_infos)) {
			$this->course_infos = array();
		}

		return parent::onAfterLoad($result);
	}

}
