<?php
/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

// No direct access
defined('_JEXEC') or die('Restricted access');

class SplmsTableCertificate extends JTable{

	public function __construct(&$db) {
		parent::__construct('#__splms_certificates', 'id', $db);
	}

	public function store($updateNulls = false) {

		$date = JFactory::getDate();
		$user = JFactory::getUser();

		if ($this->id) {
			$this->modified		= $date->toSql();
			$this->modified_by		= $user->get('id');
		} else {
			if (!(int) $this->created) {
				$this->created = $date->toSql();
			}
			if (empty($this->created_by)) {
				$this->created_by = $user->get('id');
			}
		}

		return parent::store($updateNulls);
	}

	public function check() {

		$today = JFactory::getDate();
		$today = JHtml::_('date', $today, 'Ymd');
		$rand = strtoupper(substr(uniqid(sha1(time())),0,4));
		$uniqueno = $rand .$today;

		if(empty($this->certificate_no)) {
			// Auto-fetch a alias
			$this->certificate_no = $uniqueno;
		} else {
			// if has certificate no
			$this->certificate_no = $this->certificate_no;
		}
		return true;
		//return parent::onAfterLoad($result);
	}

}
