/**
* @package com_splms
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2018 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/

-- Create syntax for TABLE '#__splms_certificates'
CREATE TABLE IF NOT EXISTS `#__splms_certificates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `userid` int(11) DEFAULT NULL,
  `coursescategory_id` int(11) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `student_image` varchar(255) DEFAULT '',
  `certificate_no` varchar(100) DEFAULT NULL,
  `instructor` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_courses'
CREATE TABLE IF NOT EXISTS `#__splms_courses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(50) NOT NULL DEFAULT '',
  `course_sub_title` varchar(55) NOT NULL,
  `coursecategory_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `short_description` varchar(255) DEFAULT NULL,
  `level` varchar(55) DEFAULT NULL,
  `image` varchar(255) NOT NULL,
  `video_url` varchar(255) NOT NULL,
  `ref_url` varchar(255) NOT NULL,
  `featured_course` tinyint(1) NOT NULL DEFAULT '0',
  `course_schedules` text NOT NULL,
  `course_infos` text NOT NULL,
  `course_time` varchar(255) NOT NULL DEFAULT '',
  `price` float(8,2) NOT NULL,
  `sale_price` float(8,2) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `download` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_coursescategories'
CREATE TABLE IF NOT EXISTS `#__splms_coursescategories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(50) NOT NULL DEFAULT '',
  `featured` tinyint(1) NOT NULL,
  `show` tinyint(1) NOT NULL,
  `icon` varchar(55) NOT NULL,
  `description` text,
  `image` varchar(255) DEFAULT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_eventcategories'
CREATE TABLE IF NOT EXISTS `#__splms_eventcategories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `alias` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) DEFAULT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_events'
CREATE TABLE IF NOT EXISTS `#__splms_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  `image` varchar(255) DEFAULT '',
  `price` int(11) DEFAULT NULL,
  `buy_url` varchar(255) DEFAULT NULL,
  `speaker_id` varchar(50) DEFAULT '',
  `eventcategory_id` bigint(20) NOT NULL,
  `event_start_date` date NOT NULL,
  `event_end_time` time NOT NULL,
  `event_time` time NOT NULL,
  `event_end_date` date NOT NULL,
  `event_address` text,
  `topics` text NOT NULL,
  `gallery` text NOT NULL,
  `pricing_tables` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_lessons'
CREATE TABLE IF NOT EXISTS `#__splms_lessons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  `short_description` varchar(255) DEFAULT '',
  `course_id` int(11) unsigned NOT NULL,
  `teacher_id` int(11) NOT NULL,
  `video_url` varchar(255) DEFAULT '',
  `vdo_thumb` text NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `video_duration` varchar(50) DEFAULT '',
  `attachment` varchar(255) DEFAULT '',
  `lesson_type` tinyint(1) NOT NULL DEFAULT '1',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_orders'
CREATE TABLE IF NOT EXISTS `#__splms_orders` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `order_user_id` bigint(20) NOT NULL,
  `course_id` bigint(20) NOT NULL,
  `order_price` float(17,2) NOT NULL,
  `order_payment_id` varchar(255) NOT NULL,
  `invoice_id` varchar(255) NOT NULL,
  `order_payment_method` varchar(255) NOT NULL DEFAULT '',
  `order_payment_price` float NOT NULL,
  `order_duration` varchar(55) NOT NULL DEFAULT '',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `payment_note` text,
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order_discount_code` varchar(255) DEFAULT '',
  `order_discount_price` decimal(17,5) DEFAULT NULL,
  `order_discount_tax` decimal(17,5) DEFAULT NULL,
  `order_payment_currency` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_quizquestions'
CREATE TABLE IF NOT EXISTS `#__splms_quizquestions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `description` text NOT NULL,
  `course_id` int(11) DEFAULT NULL,
  `list_answers` text,
  `quiz_type` tinyint(1) DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_quizresults'
CREATE TABLE IF NOT EXISTS `#__splms_quizresults` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point` int(11) DEFAULT NULL,
  `total_marks` int(11) DEFAULT NULL,
  `user_id` text NOT NULL,
  `quizquestion_id` int(11) DEFAULT NULL,
  `course_id` int(11) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_speakers'
CREATE TABLE IF NOT EXISTS `#__splms_speakers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `title` varchar(50) NOT NULL DEFAULT '',
  `alias` varchar(50) NOT NULL DEFAULT '',
  `designation` varchar(50) DEFAULT '',
  `description` text,
  `image` varchar(255) DEFAULT '',
  `website` varchar(50) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `social_facebook` varchar(50) DEFAULT '',
  `social_twitter` varchar(50) DEFAULT '',
  `social_gplus` varchar(50) DEFAULT '',
  `social_linkedin` varchar(50) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_teachers'
CREATE TABLE IF NOT EXISTS `#__splms_teachers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(50) NOT NULL DEFAULT '',
  `designation` varchar(55) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT '',
  `website` varchar(50) DEFAULT '',
  `email` varchar(100) DEFAULT '',
  `experience` varchar(255) NOT NULL,
  `specialist_in` text NOT NULL,
  `social_facebook` varchar(100) DEFAULT '',
  `social_twitter` varchar(100) DEFAULT '',
  `social_gplus` varchar(100) DEFAULT '',
  `social_linkedin` varchar(100) DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(5) NOT NULL DEFAULT '1',
  `language` char(7) NOT NULL DEFAULT '*',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_useritems'
CREATE TABLE IF NOT EXISTS `#__splms_useritems` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT '0',
  `user_id` int(11) DEFAULT NULL,
  `item_type` varchar(55) DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Create syntax for TABLE '#__splms_reviews'
CREATE TABLE IF NOT EXISTS `#__splms_reviews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` int(11) DEFAULT NULL,
  `rating` tinyint(2) DEFAULT '0',
  `review` text,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `ordering` int(10) NOT NULL DEFAULT '0',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `checked_out` bigint(20) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
