<?php
/**
 * @package     SP LMS
 *
 * @copyright   Copyright (C) 2010 - 2017 JoomShaper. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access!');

jimport('joomla.filesystem.file');

class JFormFieldTeachers extends JFormField{

	protected $type = 'Teachers';

	public function getTeachers() {

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from($db->quoteName('#__splms_teachers'));
		$query->where($db->quoteName('published')." = 1");
		$query->where('published = 1');
		$query->order('ordering DESC');
		$db->setQuery($query);

		return $db->loadObjectList();

	}

	public function getInput() {
		$teachers = $this->getTeachers();
		
		$teacherid = '';
		if ($this->value) {
			$teacherid = $this->value;
		}
		$selected = ($teacherid == '') ? 'selected' : '' ;

		$output = '';
		$output .= '<select id="'.$this->id.'" name="'.$this->name.'" onchange="this.form.submit();">';
		$output .= '<option value="" ' . $selected . '>'. JText::_('COM_SPSPLMS_FILTER_TEACHERS') .'</option>';
		foreach ($teachers as $key => $teacher) {
			$selected = ($teacher->id == $teacherid) ? 'selected' : '' ;
			$output .= '<option value="'. $teacher->id .'" ' . $selected . '>'. $teacher->title .'</option>';
		}
		$output .= '</select>';

		return $output;
	}

}
