<?php
/**
* @package RSMediaGallery!
* @copyright (C) 2011-2014 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-2.0.html
*/

defined('_JEXEC') or die('Restricted access');

class com_rsmediagalleryInstallerScript
{
	public function preflight($type, $parent) {
		$app = JFactory::getApplication();
		
		$jversion = new JVersion();
		if (!$jversion->isCompatible('3.2.0')) {
			$app->enqueueMessage('Please upgrade to at least Joomla! 3.2.0 before continuing!', 'error');
			return false;
		}
		
		return true;
	}
	
	public function postflight($type, $parent) 
	{
		if ($type == 'uninstall') {
			return true;
		}
		$db			= JFactory::getDBO();
		$messages 	= array(
			'plg_installer' => false
		);
		
		// Get the source
		$source = $parent->getParent()->getPath('source');
		
		// Get a new installer
		$installer = new JInstaller();
		
		if ($installer->install($source.'/other/plg_installer')) {
			$query = $db->getQuery(true);
			$query->update('#__extensions')
				  ->set($db->qn('enabled').'='.$db->q(1))
				  ->where($db->qn('element').'='.$db->q('rsmediagallery'))
				  ->where($db->qn('type').'='.$db->q('plugin'))
				  ->where($db->qn('folder').'='.$db->q('installer'));
			$db->setQuery($query);
			$db->execute();
			
			$messages['plg_installer'] = true;
		}

		if ($type == 'update') 
		{
			$source = $parent->getParent()->getPath('source');
			$this->runSQL($source, 'install.sql');
			
			$db->setQuery("SHOW COLUMNS FROM #__rsmediagallery_items WHERE `Field`='free_aspect'");
			if (!$db->loadResult()) 
			{
				$db->setQuery("ALTER TABLE `#__rsmediagallery_items` ADD `free_aspect` TINYINT(1) NOT NULL AFTER `params`");
				$db->execute();
			}

			$columns = $db->getTableColumns('#__rsmediagallery_thumbs', false);
			if ($columns['hash']->Key != 'MUL') {
				$db->setQuery("ALTER TABLE #__rsmediagallery_thumbs ADD INDEX (`hash`)");
				$db->execute();
			}

			$columns = $db->getTableColumns('#__rsmediagallery_effects', false);
			if ($columns['item_id']->Key != 'MUL') {
				$db->setQuery("ALTER TABLE #__rsmediagallery_effects ADD INDEX ( `item_id` ), ADD INDEX ( `item_id` , `hash` )");
				$db->execute();
			}
			
			// check for broken images
			$query = $db->getQuery(true);
			$query->select($db->qn('filename'))
			  ->from($db->qn('#__rsmediagallery_items'))
			  ->where($db->qn('params')." LIKE ".$db->q('%d:NAN%')." OR ".$db->qn('params')." LIKE ".$db->q('%d:INF%'));
			$db->setQuery($query);
			
			if ($items = $db->loadObjectList()) {
				foreach ($items as $item) {
					if (file_exists(JPATH_SITE.'/components/com_rsmediagallery/assets/gallery/original/'.$item->filename)) {
						unlink(JPATH_SITE.'/components/com_rsmediagallery/assets/gallery/original/'.$item->filename);
					}
				}
				
				// the delete query
				$db->setQuery("DELETE FROM #__rsmediagallery_items WHERE ".$db->qn('params')." LIKE ".$db->q('%d:NAN%')." OR ".$db->qn('params')." LIKE ".$db->q('%d:INF%'));
				$db->execute();
			}
		}

		// show message
		$this->showInstallMessage($messages);
	}
	
	public function uninstall($parent) {
		$plg_installer_id = 0;
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->qn('extension_id'))
			  ->from($db->qn('#__extensions'))
			  ->where($db->qn('element').'='.$db->q('rsmediagallery'))
			  ->where($db->qn('type').'='.$db->q('plugin'))
			  ->where($db->qn('folder').'='.$db->q('installer'));
		$db->setQuery($query);
		$plg_installer_id = (int) $db->loadResult();
		
		if (!empty($plg_installer_id)) {
			// Get a new installer
			$installer = new JInstaller();
			$installer->uninstall('plugin', $plg_installer_id, 1);
		}
	}
	
	protected function runSQL($source, $file) {
		$db = JFactory::getDbo();
		$driver = strtolower($db->name);
		if ($driver == 'mysqli') {
			$driver = 'mysql';
		} elseif ($driver == 'sqlsrv') {
			$driver = 'sqlazure';
		}
		
		$sqlfile = $source.'/admin/sql/'.$driver.'/'.$file;
		
		if (file_exists($sqlfile)) {
			$buffer = file_get_contents($sqlfile);
			if ($buffer !== false) {
				$queries = JInstallerHelper::splitSql($buffer);
				foreach ($queries as $query) {
					$query = trim($query);
					if ($query != '' && $query{0} != '#') {
						$db->setQuery($query);
						if (!$db->execute()) {
							JError::raiseWarning(1, JText::sprintf('JLIB_INSTALLER_ERROR_SQL_ERROR', $db->stderr(true)));
						}
					}
				}
			}
		}
	}
	
	protected function explode($string) {
		$string = str_replace(array("\r\n", "\r"), "\n", $string);
		return explode("\n", $string);
	}
	
	protected function quoteImplode($array) {
		$db = JFactory::getDbo();
		foreach ($array as $k => $v) {
			$array[$k] = $db->quote($v);
		}
		
		return implode(',', $array);
	}
	
	protected function showInstallMessage($messages=array()) {
?>
<style type="text/css">
.version-history {
	margin: 0 0 2em 0;
	padding: 0;
	list-style-type: none;
}
.version-history > li {
	margin: 0 0 0.5em 0;
	padding: 0 0 0 4em;
}
.version-new,
.version-fixed,
.version-upgraded {
	float: left;
	font-size: 0.8em;
	margin-left: -4.9em;
	width: 4.5em;
	color: white;
	text-align: center;
	font-weight: bold;
	text-transform: uppercase;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
}

.version-new {
	background: #7dc35b;
}
.version-fixed {
	background: #e9a130;
}
.version-upgraded {
	background: #61b3de;
}

.install-ok {
	background: #7dc35b;
	color: #fff;
	padding: 3px;
}

.install-not-ok {
	background: #E9452F;
	color: #fff;
	padding: 3px;
}
</style>
<div class="row-fluid">
	<div class="span2">
		<img src="components/com_rsmediagallery/assets/images/rsmediagallery-box.png" alt="RSMediaGallery! Box" />
	</div>
	<div id="span10">
		<p>Installer Plugin ...
			<?php if ($messages['plg_installer']) { ?>
			<b class="install-ok">Installed</b>
			<?php } else { ?>
			<b class="install-not-ok">Error installing!</b>
			<?php } ?>
		</p>
		
		<h2>Changelog v1.9.32</h2>
		<ul class="version-history">
			<li><span class="version-fixed">Fix</span> Accessing a direct URL without a menu item ID would show an SQL error.</li>
		</ul>
		<a class="btn btn-large btn-primary" href="index.php?option=com_rsmediagallery">Start using RSMediaGallery!</a>
		<a class="btn" href="https://www.rsjoomla.com/support/documentation/rsmediagallery.html" target="_blank">Read the RSMediaGallery! User Guide</a>
		<a class="btn" href="https://www.rsjoomla.com/support.html" target="_blank">Get Support!</a>
	</div>
</div>
		<?php
	}
}