<?php
/**
* @package RSMediaGallery!
* @copyright (C) 2011-2014 www.rsjoomla.com
* @license GPL, http://www.gnu.org/licenses/gpl-3.0.html
*/

defined('_JEXEC') or die('Restricted access');

class RSMediaGalleryControllerItems extends RSMediaGalleryController
{
	public function __construct()
	{
		parent::__construct();
		
		$this->registerTask('publishitems',   'changestatus');
		$this->registerTask('unpublishitems', 'changestatus');
		
		$this->registerTask('tagitems',   'changetag');
		$this->registerTask('untagitems', 'changetag');
	}
	
	public function getItems()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'items');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function getItem()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'item');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function saveItem()
	{		
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'save');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function uploadItem()
	{		
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'upload');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function getSuggestions()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'autocomplete');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function getImagesFtp()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'navigate');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function addImagesFtp()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'addimages');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	}
	
	public function delItems()
	{
		// pass the request to the model to delete the selected items
		$model = $this->getModel('rsmediagallery');
		$model->delItems();
		
		// now, we need to pass this to getItems() so that we can show the total images
		$this->getItems();
	}
	
	public function saveOrder()
	{
		// pass the request to the model to delete the selected items
		$model = $this->getModel('rsmediagallery');
		$model->saveOrder();
	}
	
	public function changeStatus()
	{
		// pass the request to the model to publish or unpublish the selected items
		$model = $this->getModel('rsmediagallery');
		$model->changeStatus(JFactory::getApplication()->input->getCmd('task') == 'publishitems' ? 1 : 0);
	}
	
	public function changeTag()
	{
		// pass the request to the model to tag or untag the selected items
		$model = $this->getModel('rsmediagallery');
		$model->changeTag(JFactory::getApplication()->input->getCmd('task') == 'tagitems' ? 1 : 0);
	}
	
	public function buildFilterThumb() 
	{
		$model = $this->getModel('rsmediagallery');
		$model->buildFilterThumb();
	}
	
	public function checkMemory()
	{
		JFactory::getApplication()->input->set('view',   'rsmediagallery');
		JFactory::getApplication()->input->set('layout', 'checkmemory');
		JFactory::getApplication()->input->set('format', 'raw');
		
		parent::display();
	
	}
	
	public function getAllTags() {
		$model = $this->getModel('rsmediagallery');
		$tags = $model->getAllTags();
		
		$response = new stdClass();
		$response->tags = $tags;
	
		$this->showResponse(true, $response);
	}
	
	protected function showResponse($success, $data=null) {
		$app 		= JFactory::getApplication();
		$document 	= JFactory::getDocument();
		
		// set JSON encoding
		$document->setMimeEncoding('application/json');
		
		// compute the response
		$response = new stdClass();
		$response->success = $success;
		if ($data) {
			$response->data = $data;
		}
		
		// show the response
		echo json_encode($response);
		
		// close
		$app->close();
	}
}